/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.rrls;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.redlance.dima_dencep.mods.rrls.config.DoubleLoad;
import org.redlance.dima_dencep.mods.rrls.config.HideType;
import org.redlance.dima_dencep.mods.rrls.config.Type;
import org.redlance.dima_dencep.mods.rrls.utils.Ease;

public class RrlsConfig {
    public static final Pair<RrlsConfig, ModConfigSpec> CONFIG_SPEC_PAIR = new ModConfigSpec.Builder().configure(RrlsConfig::new);
    public final ModConfigSpec.EnumValue<HideType> hideType;
    public final ModConfigSpec.BooleanValue blockOverlay;
    public final ModConfigSpec.BooleanValue miniRender;
    public final ModConfigSpec.BooleanValue enableScissor;
    public final ModConfigSpec.EnumValue<Type> type;
    public final ModConfigSpec.BooleanValue rgbProgress;
    public final ModConfigSpec.ConfigValue<String> reloadText;
    public final ModConfigSpec.ConfigValue<Double> animationSpeed;
    public final ModConfigSpec.BooleanValue interpolateProgress;
    public final ModConfigSpec.BooleanValue interpolateAtEnd;
    public final ModConfigSpec.EnumValue<Ease> ease;
    public final ModConfigSpec.ConfigValue<Double> easingArg;
    public final ModConfigSpec.BooleanValue resetResources;
    public final ModConfigSpec.BooleanValue reInitScreen;
    public final ModConfigSpec.BooleanValue earlyPackStatusSend;
    public final ModConfigSpec.EnumValue<DoubleLoad> doubleLoad;
    public final ModConfigSpec.BooleanValue skipForgeOverlay;

    protected RrlsConfig(ModConfigSpec.Builder builder) {
        builder.push("global");
        this.hideType = builder.defineEnum("hideOverlays", (Enum)HideType.ALL);
        this.blockOverlay = builder.define("blockOverlay", false);
        this.miniRender = builder.define("miniRender", true);
        this.enableScissor = builder.define("enableScissor", false);
        builder.pop();
        builder.push("splash");
        this.type = builder.defineEnum("type", (Enum)Type.PROGRESS);
        this.rgbProgress = builder.define("rgbProgress", false);
        this.reloadText = builder.define("reloadText", (Object)"Edit in config!");
        this.animationSpeed = builder.define("animationSpeed", (Object)1000.0);
        builder.pop();
        builder.push("interpolation");
        this.interpolateProgress = builder.define("interpolateProgress", false);
        this.interpolateAtEnd = builder.define("interpolateAtEnd", true);
        this.ease = builder.defineEnum("ease", (Enum)Ease.INOUTQUINT);
        this.easingArg = builder.define("easingArg", (Object)Double.NaN, RrlsConfig::isFloatLike);
        builder.pop();
        builder.push("other");
        this.resetResources = builder.define("resetResources", true);
        this.reInitScreen = builder.define("reInitScreen", true);
        this.earlyPackStatusSend = builder.define("earlyPackStatusSend", false);
        this.doubleLoad = builder.defineEnum("doubleLoad", (Enum)DoubleLoad.FORCE_LOAD);
        builder.pop();
        builder.push("platform");
        this.skipForgeOverlay = builder.define("skipForgeOverlay", false);
        builder.pop();
    }

    public static HideType hideType() {
        return (HideType)((Object)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).hideType.get());
    }

    public static boolean blockOverlay() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).blockOverlay.get();
    }

    public static boolean miniRender() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).miniRender.get();
    }

    public static boolean enableScissor() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).enableScissor.get();
    }

    public static Type type() {
        return (Type)((Object)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).type.get());
    }

    public static boolean rgbProgress() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).rgbProgress.get();
    }

    public static String reloadText() {
        return (String)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).reloadText.get();
    }

    public static boolean interpolateProgress() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).interpolateProgress.get();
    }

    public static boolean interpolateAtEnd() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).interpolateAtEnd.get();
    }

    public static Ease easing() {
        return (Ease)((Object)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).ease.get());
    }

    public static Float easingArg() {
        float easingArg = ((Double)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).easingArg.get()).floatValue();
        if (Float.isNaN(easingArg)) {
            return null;
        }
        return Float.valueOf(easingArg);
    }

    public static float animationSpeed() {
        return ((Double)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).animationSpeed.get()).floatValue();
    }

    public static boolean resetResources() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).resetResources.get();
    }

    public static boolean reInitScreen() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).reInitScreen.get();
    }

    public static boolean earlyPackStatusSend() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).earlyPackStatusSend.get();
    }

    public static DoubleLoad doubleLoad() {
        return (DoubleLoad)((Object)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).doubleLoad.get());
    }

    public static boolean skipForgeOverlay() {
        return (Boolean)((RrlsConfig)RrlsConfig.CONFIG_SPEC_PAIR.getKey()).skipForgeOverlay.get();
    }

    private static boolean isFloatLike(Object obj) {
        if (obj == null) {
            return false;
        }
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Double.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                boolean var3_4;
                Float ignored = (Float)object2;
                yield var3_4 = true;
            }
            case 1 -> {
                boolean var3_5;
                Double ignored = (Double)object2;
                yield var3_5 = true;
            }
            case 2 -> {
                String str = (String)object2;
                try {
                    boolean var3_6;
                    Float.valueOf(str);
                    yield var3_6 = true;
                }
                catch (Throwable th) {
                    boolean var3_7;
                    yield var3_7 = false;
                }
            }
            default -> {
                boolean var3_8;
                yield var3_8 = false;
            }
        };
    }
}

