/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.client.time.TimeSupplier;
import su.plo.voice.client.audio.source.JitterBuffer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsu/plo/voice/client/audio/source/StaticJitterBuffer;", "Lsu/plo/voice/client/audio/source/JitterBuffer;", "timeSupplier", "Lsu/plo/voice/api/client/time/TimeSupplier;", "packetDelay", "", "staleThresholdMillis", "", "<init>", "(Lsu/plo/voice/api/client/time/TimeSupplier;IJ)V", "queue", "Ljava/util/Queue;", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "endPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "offer", "", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "poll", "isEmpty", "", "plasmovoice-fabric-1.21.6"})
@SourceDebugExtension(value={"SMAP\nStaticJitterBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaticJitterBuffer.kt\nsu/plo/voice/client/audio/source/StaticJitterBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class StaticJitterBuffer
implements JitterBuffer {
    @NotNull
    private final TimeSupplier timeSupplier;
    private final int packetDelay;
    private final long staleThresholdMillis;
    @NotNull
    private final Queue<JitterBuffer.PacketWithSequenceNumber> queue;
    @Nullable
    private SourceAudioEndPacket endPacket;

    public StaticJitterBuffer(@NotNull TimeSupplier timeSupplier, int packetDelay, long staleThresholdMillis) {
        Intrinsics.checkNotNullParameter(timeSupplier, "timeSupplier");
        this.timeSupplier = timeSupplier;
        this.packetDelay = packetDelay;
        this.staleThresholdMillis = staleThresholdMillis;
        this.queue = this.packetDelay <= 1 ? (Queue)new LinkedBlockingQueue() : (Queue)new PriorityBlockingQueue(this.packetDelay * 2, new Comparator(){

            public final int compare(T a, T b) {
                JitterBuffer.PacketWithSequenceNumber it = (JitterBuffer.PacketWithSequenceNumber)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSequenceNumber());
                it = (JitterBuffer.PacketWithSequenceNumber)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getSequenceNumber());
            }
        });
    }

    public /* synthetic */ StaticJitterBuffer(TimeSupplier timeSupplier, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = 500L;
        }
        this(timeSupplier, n, l);
    }

    @Override
    public void offer(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (this.endPacket != null) {
            long l = packet.getSequenceNumber();
            SourceAudioEndPacket sourceAudioEndPacket = this.endPacket;
            Intrinsics.checkNotNull(sourceAudioEndPacket);
            if (l > sourceAudioEndPacket.getSequenceNumber()) {
                this.endPacket = null;
            }
        }
        this.queue.offer(new JitterBuffer.SourceAudioPacketWrapper(packet, this.timeSupplier.getCurrentTimeMillis()));
    }

    @Override
    public void offer(@NotNull SourceAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.endPacket = packet;
        this.queue.offer(new JitterBuffer.SourceAudioEndPacketWrapper(packet, this.timeSupplier.getCurrentTimeMillis()));
    }

    @Override
    @Nullable
    public JitterBuffer.PacketWithSequenceNumber poll() {
        if (this.endPacket != null || this.queue.size() >= this.packetDelay) {
            JitterBuffer.PacketWithSequenceNumber packetWithSequenceNumber;
            JitterBuffer.PacketWithSequenceNumber packetWithSequenceNumber2 = this.queue.poll();
            if (packetWithSequenceNumber2 != null) {
                JitterBuffer.PacketWithSequenceNumber packetWithSequenceNumber3;
                JitterBuffer.PacketWithSequenceNumber it = packetWithSequenceNumber3 = packetWithSequenceNumber2;
                boolean bl = false;
                packetWithSequenceNumber = this.timeSupplier.getCurrentTimeMillis() - it.getArrivalTime() < this.staleThresholdMillis ? packetWithSequenceNumber3 : null;
            } else {
                packetWithSequenceNumber = null;
            }
            return packetWithSequenceNumber;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

