/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.provider;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.provider.AudioFrameResult;
import su.plo.voice.api.server.audio.provider.CollectionAudioFrameProvider;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsu/plo/voice/api/server/audio/provider/ArrayAudioFrameProvider;", "Lsu/plo/voice/api/server/audio/provider/CollectionAudioFrameProvider;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "stereo", "", "<init>", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Z)V", "loop", "getLoop", "()Z", "setLoop", "(Z)V", "frames", "Ljava/util/ArrayList;", "", "Lsu/plo/voice/libs/kotlin/collections/ArrayList;", "getFrames", "()Ljava/util/ArrayList;", "index", "", "provide20ms", "Lsu/plo/voice/api/server/audio/provider/AudioFrameResult;", "server-proxy-common"})
public final class ArrayAudioFrameProvider
extends CollectionAudioFrameProvider {
    private boolean loop;
    @NotNull
    private final ArrayList<byte[]> frames;
    private int index;

    public ArrayAudioFrameProvider(@NotNull PlasmoBaseVoiceServer voiceServer, boolean stereo) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        super(voiceServer, stereo);
        this.frames = new ArrayList();
    }

    public final boolean getLoop() {
        return this.loop;
    }

    public final void setLoop(boolean bl) {
        this.loop = bl;
    }

    @NotNull
    protected ArrayList<byte[]> getFrames() {
        return this.frames;
    }

    @Override
    @NotNull
    public AudioFrameResult provide20ms() {
        AudioFrameResult audioFrameResult;
        if (((ArrayList)this.getFrames()).isEmpty() || ((ArrayList)this.getFrames()).size() == this.index) {
            audioFrameResult = AudioFrameResult.Finished.INSTANCE;
        } else {
            AudioFrameResult audioFrameResult2;
            Object e = ((ArrayList)this.getFrames()).get(this.index);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            byte[] frame = (byte[])e;
            AudioFrameResult it = audioFrameResult2 = frame.length == 0 ? (AudioFrameResult)AudioFrameResult.Finished.INSTANCE : (AudioFrameResult)new AudioFrameResult.Provided(frame);
            boolean bl = false;
            if (this.loop) {
                this.index = (this.index + 1) % ((ArrayList)this.getFrames()).size();
            } else {
                int n = this.index;
                this.index = n + 1;
            }
            audioFrameResult = audioFrameResult2;
        }
        return audioFrameResult;
    }
}

