/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.DirectPartValues;
import com.tom.cpm.shared.model.render.VanillaModelPart;

public enum DirectParts implements DirectPartValues
{
    CAPE(RootModelType.CAPE, new Vec3f(0.0f, 0.0f, 2.0f), new Vec3f(-6.0f, 180.0f, 0.0f)),
    ELYTRA_LEFT(RootModelType.ELYTRA_LEFT, new Vec3f(5.0f, 0.0f, 2.0f), new Vec3f((float)Math.toDegrees(0.2617993950843811), 0.0f, (float)Math.toDegrees(-0.2617993950843811))),
    ELYTRA_RIGHT(RootModelType.ELYTRA_RIGHT, new Vec3f(-5.0f, 0.0f, 2.0f), new Vec3f((float)Math.toDegrees(0.2617993950843811), 0.0f, (float)Math.toDegrees(0.2617993950843811)));

    public static final DirectParts[] VALUES;
    public final VanillaModelPart value;
    public final Vec3f pos;
    public final Vec3f rot;
    private final PartValues val;

    private DirectParts(VanillaModelPart value, Vec3f pos, Vec3f rot) {
        this.value = value;
        this.pos = pos;
        this.rot = rot;
        this.val = value.getDefaultSize(SkinType.DEFAULT);
    }

    public static PartValues getPartOverrides(VanillaModelPart val, SkinType type) {
        for (int i = 0; i < VALUES.length; ++i) {
            DirectParts g = VALUES[i];
            if (g.value != val) continue;
            return g;
        }
        return val.getDefaultSize(type);
    }

    @Override
    public Vec3f getPos() {
        return this.pos;
    }

    @Override
    public Vec3f getOffset() {
        return this.val.getOffset();
    }

    @Override
    public Vec3f getSize() {
        return this.val.getSize();
    }

    @Override
    public Vec2i getUV() {
        return this.val.getUV();
    }

    @Override
    public boolean isMirror() {
        return this.val.isMirror();
    }

    @Override
    public float getMCScale() {
        return this.val.getMCScale();
    }

    @Override
    public Vec3f getRotation() {
        return this.rot;
    }

    static {
        VALUES = DirectParts.values();
    }
}

