/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.externals.org.apache.commons.math3;

import java.util.Arrays;

public class PolynomialFunction {
    private final double[] coefficients;

    public PolynomialFunction(double[] c) {
        if (c == null) {
            throw new RuntimeException();
        }
        int n = c.length;
        if (n == 0) {
            throw new RuntimeException("No data: " + n);
        }
        while (n > 1 && c[n - 1] == 0.0) {
            --n;
        }
        this.coefficients = new double[n];
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    private static double evaluate(double[] coefficients, double argument) {
        if (coefficients == null) {
            throw new RuntimeException();
        }
        int n = coefficients.length;
        if (n == 0) {
            throw new RuntimeException("no data: " + n);
        }
        double result = coefficients[n - 1];
        for (int j = n - 2; j >= 0; --j) {
            result = argument * result + coefficients[j];
        }
        return result;
    }

    private static double[] differentiate(double[] coefficients) {
        if (coefficients == null) {
            throw new RuntimeException();
        }
        int n = coefficients.length;
        if (n == 0) {
            throw new RuntimeException("no data: " + n);
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n - 1];
        for (int i = n - 1; i > 0; --i) {
            result[i - 1] = (double)i * coefficients[i];
        }
        return result;
    }

    PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    private static String toString(double coeff) {
        String c = Double.toString(coeff);
        if (c.endsWith(".0")) {
            return c.substring(0, c.length() - 2);
        }
        return c;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction other = (PolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }
}

