/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.CustomRenderTypes;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.NativeImageIO;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.network.ModelEventType;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_526;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class MinecraftObject
implements MinecraftClientAccess {
    private final ModelDefinitionLoader<GameProfile> loader;
    private final PlayerRenderManager prm;
    private AllTagManagers tags;
    public RenderTypeBuilder<class_2960, class_1921> renderBuilder;

    public MinecraftObject() {
        MinecraftObjectHolder.setClientObject(this);
        this.loader = new ModelDefinitionLoader<GameProfile>(PlayerProfile::new, GameProfile::getId, GameProfile::getName);
        this.prm = new PlayerRenderManager();
        this.renderBuilder = new RenderTypeBuilder();
        this.renderBuilder.register(RenderMode.DEFAULT, class_1921::method_23580, 0);
        this.renderBuilder.register(RenderMode.GLOW, CustomRenderTypes::glowingEyes, 1);
        this.renderBuilder.register(RenderMode.COLOR, CustomRenderTypes::entityColorTranslucent, 0);
        this.renderBuilder.register(RenderMode.COLOR_GLOW, CustomRenderTypes::entityColorEyes, 1);
        this.renderBuilder.register(RenderMode.OUTLINE, CustomRenderTypes::linesNoDepth, 2);
    }

    public void setTags(AllTagManagers tags) {
        this.tags = tags;
    }

    @Override
    public PlayerRenderManager getPlayerRenderManager() {
        return this.prm;
    }

    @Override
    public DynamicTexture.ITexture createTexture() {
        return new DynTexture();
    }

    @Override
    public void executeOnGameThread(Runnable r) {
        class_310.method_1551().execute(r);
    }

    @Override
    public void executeNextFrame(Runnable r) {
        class_310.method_1551().method_63588(r);
    }

    @Override
    public ModelDefinitionLoader<GameProfile> getDefinitionLoader() {
        return this.loader;
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(class_1068.method_4648((UUID)class_310.method_1551().method_1548().method_44717()).comp_1629().method_52856());
    }

    @Override
    public void setEncodedGesture(int value) {
        Set s = class_310.method_1551().field_1690.field_1892;
        MinecraftObject.setEncPart(s, value, 0, class_1664.field_7563);
        MinecraftObject.setEncPart(s, value, 1, class_1664.field_7564);
        MinecraftObject.setEncPart(s, value, 2, class_1664.field_7566);
        MinecraftObject.setEncPart(s, value, 3, class_1664.field_7565);
        MinecraftObject.setEncPart(s, value, 4, class_1664.field_7568);
        MinecraftObject.setEncPart(s, value, 5, class_1664.field_7570);
        class_310.method_1551().field_1690.method_1643();
    }

    private static void setEncPart(Set<class_1664> s, int value, int off, class_1664 part) {
        if ((value & 1 << off) != 0) {
            s.add(part);
        } else {
            s.remove(part);
        }
    }

    @Override
    public boolean isInGame() {
        return class_310.method_1551().field_1724 != null;
    }

    @Override
    public Object getPlayerIDObject() {
        return class_310.method_1551().method_53462();
    }

    @Override
    public Object getCurrentPlayerIDObject() {
        class_310 mc = class_310.method_1551();
        return PlayerProfile.getPlayerProfile((class_1657)mc.field_1724);
    }

    @Override
    public List<IKeybind> getKeybinds() {
        return KeyBindings.kbs;
    }

    @Override
    public MinecraftClientAccess.ServerStatus getServerSideStatus() {
        class_310 mc = class_310.method_1551();
        class_634 conn = mc.method_1562();
        return mc.field_1724 != null ? (conn instanceof NetH && ((NetH)conn).cpm$hasMod() ? MinecraftClientAccess.ServerStatus.INSTALLED : MinecraftClientAccess.ServerStatus.SKIN_LAYERS_ONLY) : MinecraftClientAccess.ServerStatus.OFFLINE;
    }

    @Override
    public File getGameDir() {
        return class_310.method_1551().field_1697;
    }

    @Override
    public void openGui(Function<IGui, Frame> creator) {
        class_310 mc = class_310.method_1551();
        mc.method_1507((class_437)new GuiImpl(creator, mc.field_1755));
    }

    @Override
    public Runnable openSingleplayer() {
        class_310 mc = class_310.method_1551();
        return () -> mc.method_1507((class_437)new class_526(mc.field_1755));
    }

    @Override
    public NetHandler<?, ?, ?> getNetHandler() {
        return CustomPlayerModelsClient.INSTANCE.netHandler;
    }

    @Override
    public ImageIO.IImageIO getImageIO() {
        return new NativeImageIO();
    }

    @Override
    public MojangAPI getMojangAPI() {
        class_310 mc = class_310.method_1551();
        return new MojangAPI(mc.method_1548().method_1676(), mc.method_1548().method_44717(), mc.method_1548().method_1674());
    }

    @Override
    public void clearSkinCache() {
        MojangAPI.clearYggdrasilCache(class_310.method_1551().method_1495());
    }

    @Override
    public String getConnectedServer() {
        if (class_310.method_1551().method_1562() == null) {
            return null;
        }
        SocketAddress sa = Platform.getChannel(class_310.method_1551().method_1562().method_48296()).remoteAddress();
        if (sa instanceof InetSocketAddress) {
            return ((InetSocketAddress)sa).getHostString();
        }
        return null;
    }

    @Override
    public List<Object> getPlayers() {
        if (class_310.method_1551().method_1562() == null) {
            return Collections.emptyList();
        }
        return class_310.method_1551().method_1562().method_2880().stream().map(class_640::method_2966).collect(Collectors.toList());
    }

    @Override
    public Proxy getProxy() {
        return class_310.method_1551().method_1487();
    }

    @Override
    public RenderTypeBuilder<?, ?> getRenderBuilder() {
        return this.renderBuilder;
    }

    @Override
    public AllTagManagers getBuiltinTags() {
        return this.tags;
    }

    @Override
    public BiomeHandler<?> getBiomeHandler() {
        return BiomeHandlerImpl.clientImpl;
    }

    @Override
    public boolean requiresSelfEventForAnimation(ModelEventType type) {
        return type == ModelEventType.FALLING;
    }

    public static class DynTexture
    implements DynamicTexture.ITexture {
        private static int ID = 0;
        private class_1043 dynTex;
        private class_2960 loc;
        private static class_2960 bound_loc;
        private class_310 mc = class_310.method_1551();

        @Override
        public void bind() {
            if (this.loc == null) {
                return;
            }
            bound_loc = this.loc;
            if (this.mc.method_1531().method_4619(this.loc) == null) {
                this.mc.method_1531().method_4616(this.loc, (class_1044)this.dynTex);
            }
        }

        @Override
        public void load(Image texture) {
            if (this.loc == null || this.dynTex.method_68004().getWidth(0) != texture.getWidth() || this.dynTex.method_68004().getHeight(0) != texture.getHeight()) {
                if (this.loc != null) {
                    this.mc.method_1531().method_4615(this.loc);
                }
                int id = ID++;
                this.dynTex = new class_1043("CPM Dynamic Texture #" + id, texture.getWidth(), texture.getHeight(), true);
                this.loc = class_2960.method_60655((String)"cpm", (String)("dyn_" + id));
                this.mc.method_1531().method_4616(this.loc, (class_1044)this.dynTex);
            }
            class_1011 ni = NativeImageIO.createFromBufferedImage(texture);
            this.dynTex.method_4526(ni);
            this.dynTex.method_4524();
        }

        public static class_2960 getBoundLoc() {
            return bound_loc;
        }

        @Override
        public void free() {
            if (this.loc != null) {
                this.mc.method_1531().method_4615(this.loc);
            }
        }
    }
}

