/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.mixin.screen;

import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.config.Config;
import dev.terminalmc.autoreconnectrf.mixin.accessor.DisconnectedScreenAccessor;
import dev.terminalmc.autoreconnectrf.util.DisconnectScreenUtil;
import dev.terminalmc.autoreconnectrf.util.Localization;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_526;
import net.minecraft.class_7417;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_419.class})
public class DisconnectedScreenMixin
extends class_437 {
    @Shadow
    @Mutable
    @Final
    private class_437 field_2456;
    @Unique
    private boolean autoreconnectrf$canAutoReconnect;
    @Unique
    @Nullable
    private Runnable autoreconnectrf$manualCancel;

    protected DisconnectedScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void afterInit(CallbackInfo ci) {
        @Nullable class_4185 backButton = DisconnectScreenUtil.findBackButton(this);
        if (backButton == null) {
            AutoReconnect.LOG.warn("Couldn't find the back button on the disconnect screen", new Object[0]);
            return;
        }
        this.autoreconnectrf$fixBackButton(backButton);
        this.autoreconnectrf$canAutoReconnect = AutoReconnect.canReconnect();
        if (!this.autoreconnectrf$canAutoReconnect) {
            return;
        }
        this.autoreconnectrf$canAutoReconnect = this.autoreconnectrf$canAutoReconnect();
        class_4185 reconnectButton = this.autoreconnectrf$addButtons(backButton);
        if (this.autoreconnectrf$canAutoReconnect) {
            DisconnectScreenUtil.startCountdown(reconnectButton);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.autoreconnectrf$canAutoReconnect) {
            if (this.autoreconnectrf$manualCancel != null) {
                this.autoreconnectrf$manualCancel.run();
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Inject(method={"shouldCloseOnEsc"}, at={@At(value="RETURN")}, cancellable=true)
    private void shouldCloseOnEsc(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.field_2456);
    }

    @Unique
    private void autoreconnectrf$fixBackButton(class_4185 backButton) {
        if (AutoReconnect.isPlayingSingleplayer()) {
            this.field_2456 = new class_526((class_437)new class_442());
            backButton.method_25355((class_2561)class_2561.method_43471((String)"gui.toWorld"));
        }
    }

    @Unique
    private boolean autoreconnectrf$canAutoReconnect() {
        String reasonStr;
        class_2561 reason = ((DisconnectedScreenAccessor)((Object)this)).autoreconnectrf$getDetails().comp_2853();
        AutoReconnect.lastDcReasonStr = reasonStr = reason.getString();
        AutoReconnect.lastDcReasonKey = null;
        boolean match = false;
        class_7417 class_74172 = reason.method_10851();
        if (class_74172 instanceof class_2588) {
            String key;
            class_2588 tc = (class_2588)class_74172;
            AutoReconnect.lastDcReasonKey = key = tc.method_11022();
            if (key.equals("disconnect.transfer")) {
                return false;
            }
            for (String condition : Config.options().conditionKeys) {
                if (!key.contains(condition)) continue;
                AutoReconnect.LOG.info("Matched key '{}' against reason key '{}'", condition, key);
                match = true;
                break;
            }
        }
        if (!match) {
            for (Pattern condition : AutoReconnect.conditionPatterns) {
                if (!condition.matcher(reasonStr).find()) continue;
                AutoReconnect.LOG.info("Matched pattern '{}' against reason '{}'", condition, reasonStr);
                match = true;
                break;
            }
        }
        if (Config.options().conditionType) {
            return match && Config.get().hasAttempts();
        }
        return !match && Config.get().hasAttempts();
    }

    @Unique
    private class_4185 autoreconnectrf$addButtons(class_4185 backButton) {
        class_8667 layout = ((DisconnectedScreenAccessor)((Object)this)).autoreconnectrf$getLayout();
        class_4185 reconnectButton = class_4185.method_46430((class_2561)Localization.localized("message", "reconnect", new Object[0]), btn -> AutoReconnect.schedule(() -> class_310.method_1551().execute(AutoReconnect::manualReconnect), 100L, TimeUnit.MILLISECONDS)).method_46434(0, 0, backButton.method_25368(), backButton.method_25364()).method_46431();
        layout.method_52736((class_8021)reconnectButton);
        if (this.autoreconnectrf$canAutoReconnect) {
            class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061), btn -> {
                if (this.autoreconnectrf$manualCancel != null) {
                    this.autoreconnectrf$manualCancel.run();
                }
            }).method_46434(0, 0, backButton.method_25368(), backButton.method_25364()).method_46431();
            layout.method_52736((class_8021)cancelButton);
            this.autoreconnectrf$manualCancel = () -> {
                AutoReconnect.cancelActiveReconnect();
                this.autoreconnectrf$canAutoReconnect = false;
                this.method_37066((class_364)cancelButton);
                reconnectButton.field_22763 = true;
                reconnectButton.method_25355((class_2561)Localization.localized("message", "reconnect", new Object[0]));
            };
        }
        layout.method_48222();
        this.method_48640();
        this.method_37067();
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        return reconnectButton;
    }
}

