/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.main.WildfireGender;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.render.RenderStateEntityCapture;
import java.util.Calendar;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_922;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class HolidayFeaturesRenderer
extends class_3887<class_10055, class_591> {
    private final class_630 santaHat = HolidayFeaturesRenderer.createSantaHat().method_32109();
    private static final class_2960 SANTA_HAT = class_2960.method_60655((String)"wildfire_gender", (String)"textures/santa_hat.png");
    private static final boolean christmas = HolidayFeaturesRenderer.isAroundChristmas();

    public HolidayFeaturesRenderer(class_3883<class_10055, class_591> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_10055 state, float limbAngle, float limbDistance) {
        class_1309 entity = ((RenderStateEntityCapture)state).getEntity();
        if (entity == null) {
            return;
        }
        PlayerConfig config = WildfireGender.getPlayerById(entity.method_5667());
        if (config == null || !config.hasHolidayThemes()) {
            return;
        }
        this.renderSantaHat(state, matrices, vertexConsumers, light);
    }

    private void renderSantaHat(class_10055 state, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        if (!christmas) {
            return;
        }
        matrixStack.method_22903();
        try {
            int overlay = class_922.method_23622((class_10042)state, (float)0.0f);
            class_1921 hatRenderType = class_1921.method_23580((class_2960)SANTA_HAT);
            if (hatRenderType == null) {
                return;
            }
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(hatRenderType);
            if (state.field_53457) {
                matrixStack.method_22905(state.field_53454, state.field_53454, state.field_53454);
                matrixStack.method_46416(0.0f, 0.75f, 0.0f);
            }
            class_630 mPart = ((class_591)this.method_17165()).field_3398;
            matrixStack.method_46416(mPart.field_3657 * 0.0625f, mPart.field_3656 * 0.0625f, mPart.field_3655 * 0.0625f);
            if (mPart.field_3674 != 0.0f || mPart.field_3675 != 0.0f || mPart.field_3654 != 0.0f) {
                matrixStack.method_22907((Quaternionfc)new Quaternionf().rotationZYX(mPart.field_3674, mPart.field_3675, mPart.field_3654));
            }
            this.santaHat.method_22698(matrixStack, vertexConsumer, light, overlay);
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to render breast layer", (Throwable)e);
        }
        matrixStack.method_22909();
    }

    private static class_5607 createSantaHat() {
        class_5605 dilation = new class_5605(0.75f);
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("santa_hat", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation), class_5603.field_27701);
        return class_5607.method_32110((class_5609)modelData, (int)32, (int)32);
    }

    public static boolean isAroundChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }
}

