/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.api.IBreastArmorTexture;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.mixins.accessors.EquipmentRendererAccessor;
import com.wildfire.mixins.accessors.TextureManagerAccessor;
import com.wildfire.mixins.accessors.TrimSpriteKeyConstructorAccessor;
import com.wildfire.render.BreastSide;
import com.wildfire.render.GenderLayer;
import com.wildfire.render.WildfireModelRenderer;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_10055;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10201;
import net.minecraft.class_10394;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_572;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_918;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import net.minecraft.class_9998;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2ic;

@Environment(value=EnvType.CLIENT)
public class GenderArmorLayer<S extends class_10034, M extends class_572<S>>
extends GenderLayer<S, M> {
    private final class_10197 equipmentRenderer;
    private final class_10201 equipmentModelLoader;
    protected WildfireModelRenderer.BreastModelBox lBoobArmor;
    protected WildfireModelRenderer.BreastModelBox rBoobArmor;
    protected static final WildfireModelRenderer.BreastModelBox lTrim = new WildfireModelRenderer.BreastModelBox(64, 32, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 4, 0.001f, false);
    protected static final WildfireModelRenderer.BreastModelBox rTrim = new WildfireModelRenderer.BreastModelBox(64, 32, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 4, 0.001f, false);
    private EntityConfig entityConfig;
    @NotNull
    private IBreastArmorTexture textureData = IBreastArmorTexture.DEFAULT;

    private static boolean textureExists(class_2960 id) {
        class_1060 texManager = class_310.method_1551().method_1531();
        class_3300 resourceManager = ((TextureManagerAccessor)texManager).getResourceContainer();
        return resourceManager.method_14486(id).isPresent();
    }

    public GenderArmorLayer(class_3883<S, M> render, class_10201 equipmentModelLoader, class_10197 equipmentRenderer) {
        super(render);
        this.equipmentRenderer = equipmentRenderer;
        this.equipmentModelLoader = equipmentModelLoader;
        this.lBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 16, 17, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
        this.rBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 20, 17, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, false);
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, S state, float limbAngle, float limbDistance) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_1309 ent = this.getEntity(state);
        if (ent == null) {
            return;
        }
        class_1799 chestplate = ((class_10034)state).field_53418;
        class_10192 component = (class_10192)chestplate.method_58694(class_9334.field_54196);
        if (component == null || component.comp_3174() != class_1304.field_6174) {
            return;
        }
        class_5321 asset = component.comp_3176().orElse(null);
        if (asset == null) {
            return;
        }
        List layers = this.equipmentModelLoader.method_64087(asset).method_63996(class_10186.class_10190.field_54125);
        if (layers.isEmpty()) {
            return;
        }
        try {
            this.entityConfig = EntityConfig.getEntity(ent);
            if (!this.setupRender(state, this.entityConfig)) {
                return;
            }
            if (ent instanceof class_1531 && !this.genderArmor.armorStandsCopySettings()) {
                return;
            }
            int color = class_9282.method_57470((class_1799)chestplate, (int)0);
            boolean glint = chestplate.method_7958();
            this.renderSides(state, (class_572)this.method_17165(), matrixStack, side -> {
                layers.forEach(layer -> {
                    int layerColor = EquipmentRendererAccessor.invokeGetDyeColor(layer, color);
                    class_2960 texture = layer.method_64007(class_10186.class_10190.field_54125);
                    this.renderBreastArmor(texture, matrixStack, vertexConsumerProvider, light, (BreastSide)((Object)side), layerColor, glint);
                });
                class_8053 trim = (class_8053)this.armorStack.method_58694(class_9334.field_49607);
                if (trim != null) {
                    this.renderArmorTrim((class_5321<class_10394>)asset, matrixStack, vertexConsumerProvider, light, trim, glint, (BreastSide)((Object)side));
                }
            });
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to render breast armor", (Throwable)e);
        }
    }

    @Override
    protected boolean isLayerVisible(S state) {
        return this.genderArmor.coversBreasts();
    }

    @Override
    protected void resizeBox(float breastSize) {
        if (this.genderArmor == null || Objects.equals(this.textureData, this.genderArmor.texture())) {
            return;
        }
        this.textureData = this.genderArmor.texture();
        Vector2ic texSize = this.textureData.textureSize();
        Vector2ic lUV = this.textureData.leftUv();
        Vector2ic dim = this.textureData.dimensions();
        this.lBoobArmor = new WildfireModelRenderer.BreastModelBox(texSize.x(), texSize.y(), lUV.x(), lUV.y(), -4.0f, 0.0f, 0.0f, dim.x(), dim.y(), 3, 0.0f, false);
        Vector2ic rUV = this.textureData.rightUv();
        this.rBoobArmor = new WildfireModelRenderer.BreastModelBox(texSize.x(), texSize.y(), rUV.x(), rUV.y(), 0.0f, 0.0f, 0.0f, dim.x(), dim.y(), 3, 0.0f, false);
    }

    @Override
    protected void setupTransformations(S state, M model, class_4587 matrixStack, BreastSide side) {
        block4: {
            block3: {
                block2: {
                    super.setupTransformations(state, model, matrixStack, side);
                    if (!(state instanceof class_10055)) break block2;
                    class_10055 playerState = (class_10055)state;
                    if (playerState.field_53544) break block3;
                }
                if (!(state instanceof class_9998) || !this.entityConfig.hasJacketLayer()) break block4;
            }
            matrixStack.method_46416(0.0f, 0.0f, -0.015f);
            matrixStack.method_22905(1.05f, 1.05f, 1.05f);
        }
        matrixStack.method_46416(side.isLeft ? 0.001f : -0.001f, 0.015f, -0.015f);
        matrixStack.method_22905(1.05f, 1.0f, 1.0f);
    }

    protected void renderBreastArmor(class_2960 texture, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, BreastSide side, int color, boolean glint) {
        if (!GenderArmorLayer.textureExists(texture)) {
            return;
        }
        WildfireModelRenderer.BreastModelBox armor = side.isLeft ? this.lBoobArmor : this.rBoobArmor;
        class_1921 armorType = class_1921.method_25448((class_2960)texture);
        class_4588 armorVertexConsumer = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)armorType, (boolean)glint);
        GenderArmorLayer.renderBox(armor, matrixStack, armorVertexConsumer, light, class_4608.field_21444, class_9848.method_61334((int)color));
    }

    protected void renderArmorTrim(class_5321<class_10394> armorModel, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_8053 trim, boolean hasGlint, BreastSide side) {
        WildfireModelRenderer.BreastModelBox trimModelBox = side.isLeft ? lTrim : rTrim;
        class_10197.class_10199 key = TrimSpriteKeyConstructorAccessor.newKey(trim, class_10186.class_10190.field_54125, armorModel);
        class_1058 sprite = ((EquipmentRendererAccessor)this.equipmentRenderer).getTrimSprites().apply(key);
        class_4588 buffer = vertexConsumerProvider.getBuffer(class_4722.method_48480((boolean)((class_8056)trim.comp_3180().comp_349()).comp_1905()));
        class_4588 vertexConsumer = sprite.method_24108(buffer);
        GenderArmorLayer.renderBox(trimModelBox, matrixStack, vertexConsumer, light, class_4608.field_21444, -1);
        if (hasGlint) {
            class_4588 glintBuffer = vertexConsumerProvider.getBuffer(class_1921.method_27949());
            GenderArmorLayer.renderBox(trimModelBox, matrixStack, glintBuffer, light, class_4608.field_21444, -1);
        }
    }
}

