/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.mojang.datafixers.util.Function7;
import com.wildfire.main.Gender;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.PlayerConfig;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.class_4844;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

abstract class AbstractSyncPacket {
    protected final UUID uuid;
    protected final Gender gender;
    protected final float bustSize;
    protected final boolean hurtSounds;
    protected final float voicePitch;
    protected final BreastPhysics physics;
    protected final Breasts breasts;

    protected static <T extends AbstractSyncPacket> class_9139<ByteBuf, T> codec(SyncPacketConstructor<T> constructor) {
        return class_9139.method_64265((class_9139)class_4844.field_48453, p -> p.uuid, Gender.CODEC, p -> p.gender, (class_9139)class_9135.field_48552, p -> Float.valueOf(p.bustSize), (class_9139)class_9135.field_48547, p -> p.hurtSounds, (class_9139)class_9135.field_48552, p -> Float.valueOf(p.voicePitch), BreastPhysics.CODEC, p -> p.physics, Breasts.CODEC, p -> p.breasts, constructor);
    }

    protected AbstractSyncPacket(UUID uuid, Gender gender, float bustSize, boolean hurtSounds, float voicePitch, BreastPhysics physics, Breasts breasts) {
        this.uuid = uuid;
        this.gender = gender;
        this.bustSize = bustSize;
        this.hurtSounds = hurtSounds;
        this.voicePitch = voicePitch;
        this.physics = physics;
        this.breasts = breasts;
    }

    protected AbstractSyncPacket(PlayerConfig plr) {
        this(plr.uuid, plr.getGender(), plr.getBustSize(), plr.hasHurtSounds(), plr.getVoicePitch(), new BreastPhysics(plr), plr.getBreasts());
    }

    protected void updatePlayerFromPacket(PlayerConfig plr) {
        plr.updateGender(this.gender);
        plr.updateBustSize(this.bustSize);
        plr.updateHurtSounds(this.hurtSounds);
        plr.updateVoicePitch(this.voicePitch);
        this.physics.applyTo(plr);
        plr.getBreasts().copyFrom(this.breasts);
    }

    protected record BreastPhysics(boolean physics, boolean showInArmor, float bounceMultiplier, float floppyMultiplier) {
        public static final class_9139<ByteBuf, BreastPhysics> CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, BreastPhysics::physics, (class_9139)class_9135.field_48547, BreastPhysics::showInArmor, (class_9139)class_9135.field_48552, BreastPhysics::bounceMultiplier, (class_9139)class_9135.field_48552, BreastPhysics::floppyMultiplier, BreastPhysics::new);

        private BreastPhysics(PlayerConfig plr) {
            this(plr.hasBreastPhysics(), plr.showBreastsInArmor(), plr.getBounceMultiplier(), plr.getFloppiness());
        }

        private void applyTo(PlayerConfig plr) {
            plr.updateBreastPhysics(this.physics);
            plr.updateShowBreastsInArmor(this.showInArmor);
            plr.updateBounceMultiplier(this.bounceMultiplier);
            plr.updateFloppiness(this.floppyMultiplier);
        }
    }

    @FunctionalInterface
    protected static interface SyncPacketConstructor<T extends AbstractSyncPacket>
    extends Function7<UUID, Gender, Float, Boolean, Float, BreastPhysics, Breasts, T> {
    }
}

