/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.entitydata;

import com.google.gson.JsonObject;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.Gender;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireLocalization;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.cloud.SyncLog;
import com.wildfire.main.config.ConfigKey;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.config.GlobalConfig;
import com.wildfire.main.entitydata.EntityConfig;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerConfig
extends EntityConfig {
    public boolean needsSync;
    public boolean needsCloudSync;
    public SyncStatus syncStatus = SyncStatus.UNKNOWN;
    private final Configuration cfg;
    protected boolean hurtSounds = (Boolean)Configuration.HURT_SOUNDS.getDefault();
    protected boolean holidayThemes = (Boolean)Configuration.HOLIDAY_THEMES.getDefault();
    protected boolean armorPhysOverride = (Boolean)Configuration.ARMOR_PHYSICS_OVERRIDE.getDefault();
    protected boolean showBreastsInArmor = (Boolean)Configuration.SHOW_IN_ARMOR.getDefault();

    @Deprecated
    public PlayerConfig(UUID uuid, Gender gender) {
        this(uuid);
        this.updateGender(gender);
    }

    public PlayerConfig(UUID uuid) {
        super(uuid);
        this.cfg = new Configuration(this.uuid.toString());
        this.cfg.set(Configuration.USERNAME, this.uuid);
        this.cfg.setDefault(Configuration.GENDER);
        this.cfg.setDefault(Configuration.BUST_SIZE);
        this.cfg.setDefault(Configuration.HURT_SOUNDS);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_X);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_Y);
        this.cfg.setDefault(Configuration.BREASTS_OFFSET_Z);
        this.cfg.setDefault(Configuration.BREASTS_UNIBOOB);
        this.cfg.setDefault(Configuration.BREASTS_CLEAVAGE);
        this.cfg.setDefault(Configuration.BREAST_PHYSICS);
        this.cfg.setDefault(Configuration.ARMOR_PHYSICS_OVERRIDE);
        this.cfg.setDefault(Configuration.SHOW_IN_ARMOR);
        this.cfg.setDefault(Configuration.BOUNCE_MULTIPLIER);
        this.cfg.setDefault(Configuration.FLOPPY_MULTIPLIER);
        this.cfg.setDefault(Configuration.VOICE_PITCH);
        this.cfg.setDefault(Configuration.HOLIDAY_THEMES);
        if (uuid.version() != 4) {
            this.holidayThemes = false;
        }
    }

    @Override
    public void readFromStack(@NotNull class_1799 chestplate) {
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    private <VALUE> boolean updateValue(ConfigKey<VALUE> key, VALUE value, Consumer<VALUE> setter) {
        if (key.validate(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public boolean updateGender(Gender value) {
        return this.updateValue(Configuration.GENDER, value, v -> {
            this.gender = v;
        });
    }

    public boolean updateBustSize(float value) {
        return this.updateValue(Configuration.BUST_SIZE, Float.valueOf(value), v -> {
            this.pBustSize = v.floatValue();
        });
    }

    public boolean hasHolidayThemes() {
        return this.holidayThemes;
    }

    public boolean updateHolidayThemes(boolean value) {
        return this.updateValue(Configuration.HOLIDAY_THEMES, value, v -> {
            this.holidayThemes = v;
        });
    }

    public boolean hasHurtSounds() {
        return this.hurtSounds;
    }

    public boolean updateVoicePitch(float value) {
        return this.updateValue(Configuration.VOICE_PITCH, Float.valueOf(value), v -> {
            this.voicePitch = v.floatValue();
        });
    }

    public boolean updateHurtSounds(boolean value) {
        return this.updateValue(Configuration.HURT_SOUNDS, value, v -> {
            this.hurtSounds = v;
        });
    }

    public boolean updateBreastPhysics(boolean value) {
        return this.updateValue(Configuration.BREAST_PHYSICS, value, v -> {
            this.breastPhysics = v;
        });
    }

    @Override
    public boolean getArmorPhysicsOverride() {
        return this.armorPhysOverride;
    }

    public boolean updateArmorPhysicsOverride(boolean value) {
        return this.updateValue(Configuration.ARMOR_PHYSICS_OVERRIDE, value, v -> {
            this.armorPhysOverride = v;
        });
    }

    @Override
    public boolean showBreastsInArmor() {
        return this.showBreastsInArmor;
    }

    public boolean updateShowBreastsInArmor(boolean value) {
        return this.updateValue(Configuration.SHOW_IN_ARMOR, value, v -> {
            this.showBreastsInArmor = v;
        });
    }

    public boolean updateBounceMultiplier(float value) {
        return this.updateValue(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(value), v -> {
            this.bounceMultiplier = v.floatValue();
        });
    }

    public boolean updateFloppiness(float value) {
        return this.updateValue(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(value), v -> {
            this.floppyMultiplier = v.floatValue();
        });
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    @Deprecated
    public static JsonObject toJsonObject(PlayerConfig plr) {
        return plr.toJson();
    }

    public JsonObject toJson() {
        return this.cfg.SAVE_VALUES.deepCopy();
    }

    public boolean hasLocalConfig() {
        return this.cfg.exists();
    }

    public void loadFromDisk(boolean markForSync) {
        this.syncStatus = SyncStatus.CACHED;
        this.cfg.load();
        this.loadFromConfig(markForSync);
    }

    public void loadFromConfig(boolean markForSync) {
        this.updateGender(this.cfg.get(Configuration.GENDER));
        this.updateBustSize(this.cfg.get(Configuration.BUST_SIZE).floatValue());
        this.updateHurtSounds(this.cfg.get(Configuration.HURT_SOUNDS));
        this.updateVoicePitch(this.cfg.get(Configuration.VOICE_PITCH).floatValue());
        this.updateHolidayThemes(this.cfg.get(Configuration.HOLIDAY_THEMES));
        this.updateBreastPhysics(this.cfg.get(Configuration.BREAST_PHYSICS));
        this.updateShowBreastsInArmor(this.cfg.get(Configuration.SHOW_IN_ARMOR));
        this.updateArmorPhysicsOverride(this.cfg.get(Configuration.ARMOR_PHYSICS_OVERRIDE));
        this.updateBounceMultiplier(this.cfg.get(Configuration.BOUNCE_MULTIPLIER).floatValue());
        this.updateFloppiness(this.cfg.get(Configuration.FLOPPY_MULTIPLIER).floatValue());
        this.breasts.updateXOffset(this.cfg.get(Configuration.BREASTS_OFFSET_X).floatValue());
        this.breasts.updateYOffset(this.cfg.get(Configuration.BREASTS_OFFSET_Y).floatValue());
        this.breasts.updateZOffset(this.cfg.get(Configuration.BREASTS_OFFSET_Z).floatValue());
        this.breasts.updateUniboob(this.cfg.get(Configuration.BREASTS_UNIBOOB));
        this.breasts.updateCleavage(this.cfg.get(Configuration.BREASTS_CLEAVAGE).floatValue());
        if (markForSync) {
            this.needsSync = true;
        }
    }

    @Deprecated
    public static PlayerConfig loadCachedPlayer(UUID uuid, boolean markForSync) {
        PlayerConfig plr = WildfireGender.getPlayerById(uuid);
        if (plr != null && plr.hasLocalConfig()) {
            plr.loadFromDisk(markForSync);
        }
        return plr;
    }

    public static void saveGenderInfo(PlayerConfig plr) {
        Configuration config = plr.getConfig();
        config.set(Configuration.USERNAME, plr.uuid);
        config.set(Configuration.GENDER, plr.getGender());
        config.set(Configuration.BUST_SIZE, Float.valueOf(plr.getBustSize()));
        config.set(Configuration.HURT_SOUNDS, plr.hasHurtSounds());
        config.set(Configuration.VOICE_PITCH, Float.valueOf(plr.getVoicePitch()));
        config.set(Configuration.HOLIDAY_THEMES, plr.hasHolidayThemes());
        config.set(Configuration.BREAST_PHYSICS, plr.hasBreastPhysics());
        config.set(Configuration.SHOW_IN_ARMOR, plr.showBreastsInArmor());
        config.set(Configuration.ARMOR_PHYSICS_OVERRIDE, plr.getArmorPhysicsOverride());
        config.set(Configuration.BOUNCE_MULTIPLIER, Float.valueOf(plr.getBounceMultiplier()));
        config.set(Configuration.FLOPPY_MULTIPLIER, Float.valueOf(plr.getFloppiness()));
        config.set(Configuration.BREASTS_OFFSET_X, Float.valueOf(plr.getBreasts().getXOffset()));
        config.set(Configuration.BREASTS_OFFSET_Y, Float.valueOf(plr.getBreasts().getYOffset()));
        config.set(Configuration.BREASTS_OFFSET_Z, Float.valueOf(plr.getBreasts().getZOffset()));
        config.set(Configuration.BREASTS_UNIBOOB, plr.getBreasts().isUniboob());
        config.set(Configuration.BREASTS_CLEAVAGE, Float.valueOf(plr.getBreasts().getCleavage()));
        config.save();
        plr.needsSync = true;
        plr.needsCloudSync = true;
    }

    @Override
    public boolean hasJacketLayer() {
        throw new UnsupportedOperationException("PlayerConfig does not support #hasJacketLayer(); use PlayerEntity#isPartVisible instead");
    }

    @ApiStatus.Internal
    public void attemptCloudSync() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !this.uuid.equals(client.field_1724.method_5667())) {
            return;
        }
        if (!this.needsCloudSync) {
            return;
        }
        if (client.field_1755 instanceof BaseWildfireScreen) {
            return;
        }
        if (!GlobalConfig.INSTANCE.get(GlobalConfig.AUTOMATIC_CLOUD_SYNC).booleanValue()) {
            return;
        }
        if (CloudSync.syncOnCooldown()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                CloudSync.sync(this).join();
                WildfireGender.LOGGER.info("Synced player data to the cloud");
                SyncLog.add(WildfireLocalization.SYNC_LOG_SYNC_TO_CLOUD);
            }
            catch (Exception e) {
                WildfireGender.LOGGER.error("Failed to sync player data", (Throwable)e);
                SyncLog.add(WildfireLocalization.SYNC_LOG_FAILED_TO_SYNC_DATA);
            }
        });
        this.needsCloudSync = false;
    }

    public void updateFromJson(@NotNull JsonObject json) {
        json.asMap().forEach((arg_0, arg_1) -> ((JsonObject)this.cfg.SAVE_VALUES).add(arg_0, arg_1));
        this.loadFromConfig(false);
        this.syncStatus = SyncStatus.SYNCED;
    }

    public static enum SyncStatus {
        CACHED,
        SYNCED,
        UNKNOWN;

    }
}

