/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.wildfire.gui.WildfireBreastPresetList;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.WildfireSlider;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.config.BreastPresetConfiguration;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.config.GlobalConfig;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.PlayerConfig;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class WildfireBreastCustomizationScreen
extends BaseWildfireScreen {
    private static final class_2561 ENABLED = class_2561.method_43471((String)"wildfire_gender.label.enabled").method_27692(class_124.field_1060);
    private static final class_2561 DISABLED = class_2561.method_43471((String)"wildfire_gender.label.disabled").method_27692(class_124.field_1061);
    private static final class_2960 BACKGROUND_FEMALE = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/breast_customization.png");
    private static final class_2960 BACKGROUND_OTHER = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/breast_customization_other.png");
    private static final class_2960 BACKGROUND_CUSTOMIZATION = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/tabs/breast_customization_tab.png");
    private static final class_2960 BACKGROUND_PHYSICS = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/tabs/breast_physics_tab.png");
    private static final class_2960 BACKGROUND_MISC = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/tabs/miscellaneous_tab.png");
    private WildfireSlider breastSlider;
    private WildfireSlider xOffsetBoobSlider;
    private WildfireSlider yOffsetBoobSlider;
    private WildfireSlider zOffsetBoobSlider;
    private WildfireSlider cleavageSlider;
    private WildfireButton btnDualPhysics;
    private WildfireButton btnPhysics;
    private WildfireButton btnCustomization;
    private WildfireButton btnMiscellaneous;
    private WildfireSlider bounceSlider;
    private WildfireSlider floppySlider;
    private WildfireButton btnOverrideArmorPhys;
    private WildfireButton btnBreastPhysics;
    private WildfireSlider voicePitchSlider;
    private WildfireButton btnHurtSounds;
    private WildfireButton btnHideInArmor;
    private WildfireButton btnShowTooltips;
    private WildfireButton btnHolidayThemes;
    private WildfireBreastPresetList PRESET_LIST;
    private int currentTab = 0;

    public WildfireBreastCustomizationScreen(class_437 parent, UUID uuid) {
        super((class_2561)class_2561.method_43471((String)"wildfire_gender.appearance_settings.title"), parent, uuid);
    }

    public void method_25426() {
        int j = this.field_22790 / 2 - 11;
        int xPos = this.field_22789 / 2;
        int yPos = this.field_22790 / 2;
        PlayerConfig plr = Objects.requireNonNull(this.getPlayer(), "getPlayer()");
        Breasts breasts = plr.getBreasts();
        FloatConsumer onSave = value -> PlayerConfig.saveGenderInfo(plr);
        this.btnCustomization = new WildfireButton(this.field_22789 / 2 - 130, j - 52, 84, 12, (class_2561)class_2561.method_43471((String)"wildfire_gender.breast_customization.tab_customization"), button -> {
            this.currentTab = 0;
            this.updateTabs();
        });
        ((WildfireButton)this.method_37063((class_364)this.btnCustomization)).setActive(false);
        this.btnPhysics = new WildfireButton(this.field_22789 / 2 - 42, j - 52, 84, 12, (class_2561)class_2561.method_43471((String)"wildfire_gender.breast_customization.tab_physics"), button -> {
            this.currentTab = 1;
            this.updateTabs();
        });
        this.method_37063((class_364)this.btnPhysics);
        this.btnMiscellaneous = new WildfireButton(this.field_22789 / 2 + 46, j - 52, 84, 12, (class_2561)class_2561.method_43471((String)"wildfire_gender.breast_customization.tab_miscellaneous"), button -> {
            this.currentTab = 2;
            this.updateTabs();
        });
        this.method_37063((class_364)this.btnMiscellaneous);
        int tabOffsetY = j - 3 - 21;
        this.breastSlider = new WildfireSlider(this.field_22789 / 2 - 36, tabOffsetY - 2, 166, 20, Configuration.BUST_SIZE, plr.getBustSize(), plr::updateBustSize, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.wardrobe.slider.breast_size", (Object[])new Object[]{Math.round(value * 1.25f * 100.0f)})), onSave);
        this.method_37063((class_364)this.breastSlider);
        this.breastSlider.setArrowKeyStep(0.01);
        this.xOffsetBoobSlider = new WildfireSlider(this.field_22789 / 2 - 36, tabOffsetY + 22, 81, 20, Configuration.BREASTS_OFFSET_X, breasts.getXOffset(), breasts::updateXOffset, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.wardrobe.slider.separation", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 10.0f)})), onSave);
        this.method_37063((class_364)this.xOffsetBoobSlider);
        this.yOffsetBoobSlider = new WildfireSlider(this.field_22789 / 2 - 36 + 83 + 2, tabOffsetY + 22, 81, 20, Configuration.BREASTS_OFFSET_Y, breasts.getYOffset(), breasts::updateYOffset, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.wardrobe.slider.height", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 10.0f)})), onSave);
        this.method_37063((class_364)this.yOffsetBoobSlider);
        this.zOffsetBoobSlider = new WildfireSlider(this.field_22789 / 2 - 36, tabOffsetY + 46, 81, 20, Configuration.BREASTS_OFFSET_Z, breasts.getZOffset(), breasts::updateZOffset, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.wardrobe.slider.depth", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 10.0f)})), onSave);
        this.method_37063((class_364)this.zOffsetBoobSlider);
        this.zOffsetBoobSlider.setArrowKeyStep(0.1);
        this.cleavageSlider = new WildfireSlider(this.field_22789 / 2 - 36 + 83 + 2, tabOffsetY + 46, 81, 20, Configuration.BREASTS_CLEAVAGE, breasts.getCleavage(), breasts::updateCleavage, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.wardrobe.slider.rotation", (Object[])new Object[]{Math.round((float)Math.round(value * 100.0f) / 100.0f * 100.0f)})), onSave);
        this.method_37063((class_364)this.cleavageSlider);
        this.cleavageSlider.setArrowKeyStep(0.1);
        this.btnBreastPhysics = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY - 2, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.physics", (Object[])new Object[]{plr.hasBreastPhysics() ? ENABLED : DISABLED}), button -> {
            boolean enablePhysics;
            boolean bl = enablePhysics = !plr.hasBreastPhysics();
            if (plr.updateBreastPhysics(enablePhysics)) {
                this.bounceSlider.field_22763 = plr.hasBreastPhysics();
                this.floppySlider.field_22763 = plr.hasBreastPhysics();
                this.btnOverrideArmorPhys.field_22763 = plr.hasBreastPhysics();
                this.btnDualPhysics.field_22763 = plr.hasBreastPhysics();
                button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.physics", (Object[])new Object[]{enablePhysics ? ENABLED : DISABLED}));
                PlayerConfig.saveGenderInfo(plr);
            }
        });
        this.method_37063((class_364)this.btnBreastPhysics);
        this.btnDualPhysics = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY + 22, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.breast_customization.dual_physics", (Object[])new Object[]{class_2561.method_43471((String)(breasts.isUniboob() ? "wildfire_gender.label.no" : "wildfire_gender.label.yes"))}), button -> {
            boolean isUniboob;
            boolean bl = isUniboob = !breasts.isUniboob();
            if (breasts.updateUniboob(isUniboob)) {
                button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.breast_customization.dual_physics", (Object[])new Object[]{class_2561.method_43471((String)(isUniboob ? "wildfire_gender.label.no" : "wildfire_gender.label.yes"))}));
                PlayerConfig.saveGenderInfo(plr);
            }
        });
        this.method_37063((class_364)this.btnDualPhysics);
        this.btnDualPhysics.field_22763 = plr.hasBreastPhysics();
        this.btnOverrideArmorPhys = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY + 70, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.override_armor_physics", (Object[])new Object[]{plr.getArmorPhysicsOverride() ? ENABLED : DISABLED}), button -> {
            boolean enableArmorPhysicsOverride;
            boolean bl = enableArmorPhysicsOverride = !plr.getArmorPhysicsOverride();
            if (plr.updateArmorPhysicsOverride(enableArmorPhysicsOverride)) {
                button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.override_armor_physics", (Object[])new Object[]{plr.getArmorPhysicsOverride() ? ENABLED : DISABLED}));
                PlayerConfig.saveGenderInfo(plr);
            }
        }, class_7919.method_47407((class_2561)class_2561.method_43471((String)"wildfire_gender.tooltip.override_armor_physics.line1").method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"wildfire_gender.tooltip.override_armor_physics.line2"))));
        this.method_37063((class_364)this.btnOverrideArmorPhys);
        this.btnOverrideArmorPhys.field_22763 = plr.hasBreastPhysics();
        this.bounceSlider = new WildfireSlider(this.field_22789 / 2 - 36, tabOffsetY + 46, 81, 20, Configuration.BOUNCE_MULTIPLIER, plr.getBounceMultiplier(), value -> {}, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> {
            float bounceText = 3.0f * value;
            int v = Math.round(bounceText * 100.0f);
            return class_2561.method_43469((String)"wildfire_gender.slider.bounce", (Object[])new Object[]{v});
        }), value -> {
            if (plr.updateBounceMultiplier(value)) {
                PlayerConfig.saveGenderInfo(plr);
            }
        });
        this.method_37063((class_364)this.bounceSlider);
        this.bounceSlider.field_22763 = plr.hasBreastPhysics();
        this.bounceSlider.setArrowKeyStep(0.005);
        this.floppySlider = new WildfireSlider(this.field_22789 / 2 - 36 + 83 + 2, tabOffsetY + 46, 81, 20, Configuration.FLOPPY_MULTIPLIER, plr.getFloppiness(), value -> {}, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.slider.floppy", (Object[])new Object[]{Math.round(value * 100.0f)})), value -> {
            if (plr.updateFloppiness(value)) {
                PlayerConfig.saveGenderInfo(plr);
            }
        });
        this.method_37063((class_364)this.floppySlider);
        this.floppySlider.field_22763 = plr.hasBreastPhysics();
        this.floppySlider.setArrowKeyStep(0.01);
        this.btnHurtSounds = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY - 2, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.hurt_sounds", (Object[])new Object[]{plr.hasHurtSounds() ? ENABLED : DISABLED}), button -> {
            boolean enableHurtSounds;
            boolean bl = enableHurtSounds = !plr.hasHurtSounds();
            if (plr.updateHurtSounds(enableHurtSounds)) {
                this.voicePitchSlider.field_22763 = plr.hasHurtSounds();
                button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.hurt_sounds", (Object[])new Object[]{enableHurtSounds ? ENABLED : DISABLED}));
                PlayerConfig.saveGenderInfo(plr);
            }
        }, class_7919.method_47407((class_2561)class_2561.method_43471((String)"wildfire_gender.tooltip.hurt_sounds")));
        this.method_37063((class_364)this.btnHurtSounds);
        this.voicePitchSlider = new WildfireSlider(this.field_22789 / 2 - 36, tabOffsetY + 22, 81, 20, Configuration.VOICE_PITCH, plr.getVoicePitch(), value -> {}, (Float2ObjectFunction<class_2561>)((Float2ObjectFunction)value -> class_2561.method_43469((String)"wildfire_gender.slider.voice_pitch", (Object[])new Object[]{Math.round(value * 100.0f)})), value -> {
            if (plr.updateVoicePitch(value)) {
                class_3414 hurtSound;
                PlayerConfig.saveGenderInfo(plr);
                if (this.field_22787.field_1724 != null && (hurtSound = plr.getGender().getHurtSound()) != null) {
                    float pitch = (this.field_22787.field_1724.method_59922().method_43057() - this.field_22787.field_1724.method_59922().method_43057()) * 0.2f;
                    this.field_22787.field_1724.method_5783(hurtSound, 1.0f, pitch + plr.getVoicePitch());
                }
            }
        });
        this.method_37063((class_364)this.voicePitchSlider);
        this.voicePitchSlider.field_22763 = plr.hasHurtSounds();
        this.voicePitchSlider.setArrowKeyStep(0.01);
        this.btnHideInArmor = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY + 46, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.hide_in_armor", (Object[])new Object[]{plr.showBreastsInArmor() ? DISABLED : ENABLED}), button -> {
            boolean enableShowInArmor;
            boolean bl = enableShowInArmor = !plr.showBreastsInArmor();
            if (plr.updateShowBreastsInArmor(enableShowInArmor)) {
                button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.hide_in_armor", (Object[])new Object[]{enableShowInArmor ? DISABLED : ENABLED}));
                PlayerConfig.saveGenderInfo(plr);
            }
        });
        this.method_37063((class_364)this.btnHideInArmor);
        GlobalConfig config = GlobalConfig.INSTANCE;
        this.btnShowTooltips = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY + 70, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.show_armor_stat", (Object[])new Object[]{config.get(GlobalConfig.ARMOR_STAT) != false ? ENABLED : DISABLED}), button -> {
            config.set(GlobalConfig.ARMOR_STAT, config.get(GlobalConfig.ARMOR_STAT) == false);
            config.save();
            button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.char_settings.show_armor_stat", (Object[])new Object[]{config.get(GlobalConfig.ARMOR_STAT) != false ? ENABLED : DISABLED}));
        });
        this.method_37063((class_364)this.btnShowTooltips);
        this.btnHolidayThemes = new WildfireButton(this.field_22789 / 2 - 36, tabOffsetY + 94, 166, 20, (class_2561)class_2561.method_43469((String)"wildfire_gender.misc.holiday_themes", (Object[])new Object[]{plr.hasHolidayThemes() ? ENABLED : DISABLED}), button -> {
            boolean enableHolidayThemes;
            boolean bl = enableHolidayThemes = !plr.hasHolidayThemes();
            if (plr.updateHolidayThemes(enableHolidayThemes)) {
                button.method_25355((class_2561)class_2561.method_43469((String)"wildfire_gender.misc.holiday_themes", (Object[])new Object[]{plr.hasHolidayThemes() ? ENABLED : DISABLED}));
            }
        }, class_7919.method_47407((class_2561)class_2561.method_43471((String)"wildfire_gender.tooltip.holiday_themes.line1")));
        this.method_37063((class_364)this.btnHolidayThemes);
        this.PRESET_LIST = new WildfireBreastPresetList(this, 156, j - 48);
        this.PRESET_LIST.method_46421(this.field_22789 / 2 + 30);
        this.PRESET_LIST.method_53533(125);
        this.method_25429((class_364)this.PRESET_LIST);
        this.updateTabs();
        super.method_25426();
    }

    private void updateTabs() {
        this.btnCustomization.field_22763 = this.currentTab != 0;
        this.btnPhysics.field_22763 = this.currentTab != 1;
        this.btnMiscellaneous.field_22763 = this.currentTab != 2;
        this.breastSlider.field_22764 = this.currentTab == 0;
        this.xOffsetBoobSlider.field_22764 = this.currentTab == 0;
        this.yOffsetBoobSlider.field_22764 = this.currentTab == 0;
        this.zOffsetBoobSlider.field_22764 = this.currentTab == 0;
        this.cleavageSlider.field_22764 = this.currentTab == 0;
        this.btnBreastPhysics.field_22764 = this.currentTab == 1;
        this.btnDualPhysics.field_22764 = this.currentTab == 1;
        this.bounceSlider.field_22764 = this.currentTab == 1;
        this.floppySlider.field_22764 = this.currentTab == 1;
        this.btnOverrideArmorPhys.field_22764 = this.currentTab == 1;
        this.btnHideInArmor.field_22764 = this.currentTab == 2;
        this.btnHurtSounds.field_22764 = this.currentTab == 2;
        this.voicePitchSlider.field_22764 = this.currentTab == 2;
        this.btnShowTooltips.field_22764 = this.currentTab == 2;
        this.btnHolidayThemes.field_22764 = this.currentTab == 2;
    }

    private void createNewPreset(String presetName) {
        BreastPresetConfiguration cfg = new BreastPresetConfiguration(presetName);
        PlayerConfig plr = Objects.requireNonNull(this.getPlayer(), "getPlayer()");
        cfg.set(BreastPresetConfiguration.PRESET_NAME, presetName);
        cfg.set(BreastPresetConfiguration.BUST_SIZE, Float.valueOf(plr.getBustSize()));
        cfg.set(BreastPresetConfiguration.BREASTS_UNIBOOB, plr.getBreasts().isUniboob());
        cfg.set(BreastPresetConfiguration.BREASTS_CLEAVAGE, Float.valueOf(plr.getBreasts().getCleavage()));
        cfg.set(BreastPresetConfiguration.BREASTS_OFFSET_X, Float.valueOf(plr.getBreasts().getXOffset()));
        cfg.set(BreastPresetConfiguration.BREASTS_OFFSET_Y, Float.valueOf(plr.getBreasts().getYOffset()));
        cfg.set(BreastPresetConfiguration.BREASTS_OFFSET_Z, Float.valueOf(plr.getBreasts().getZOffset()));
        cfg.save();
        this.PRESET_LIST.refreshList();
    }

    private void updatePresetTab() {
        PlayerConfig plr = this.getPlayer();
        if (plr == null) {
            return;
        }
        boolean canHaveBreasts = plr.getGender().canHaveBreasts();
        this.breastSlider.field_22764 = canHaveBreasts && this.currentTab == 0;
        this.xOffsetBoobSlider.field_22764 = canHaveBreasts && this.currentTab == 0;
        this.yOffsetBoobSlider.field_22764 = canHaveBreasts && this.currentTab == 0;
        this.zOffsetBoobSlider.field_22764 = canHaveBreasts && this.currentTab == 0;
        this.cleavageSlider.field_22764 = canHaveBreasts && this.currentTab == 0;
        this.btnDualPhysics.field_22764 = canHaveBreasts && this.currentTab == 0;
        this.PRESET_LIST.visible = this.currentTab == 1;
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_2960 backgroundTexture;
        this.method_52752(ctx);
        PlayerConfig plr = this.getPlayer();
        if (plr == null) {
            return;
        }
        switch (plr.getGender()) {
            default: {
                throw new MatchException(null, null);
            }
            case MALE: {
                class_2960 class_29602 = null;
                break;
            }
            case FEMALE: {
                class_2960 class_29602 = BACKGROUND_FEMALE;
                break;
            }
            case OTHER: {
                class_2960 class_29602 = backgroundTexture = BACKGROUND_OTHER;
            }
        }
        if (backgroundTexture != null) {
            ctx.method_25290(class_10799.field_56883, backgroundTexture, (this.field_22789 - 272) / 2, (this.field_22790 - 138) / 2, 0.0f, 0.0f, 272, 130, 512, 512);
        }
        if (this.currentTab == 0) {
            ctx.method_25290(class_10799.field_56883, BACKGROUND_CUSTOMIZATION, this.field_22789 / 2 - 42, this.field_22790 / 2 - 43, 0.0f, 0.0f, 178, 80, 512, 512);
        } else if (this.currentTab == 1) {
            ctx.method_25290(class_10799.field_56883, BACKGROUND_PHYSICS, this.field_22789 / 2 - 42, this.field_22790 / 2 - 43, 0.0f, 0.0f, 178, 104, 512, 512);
        } else if (this.currentTab == 2) {
            ctx.method_25290(class_10799.field_56883, BACKGROUND_MISC, this.field_22789 / 2 - 42, this.field_22790 / 2 - 43, 0.0f, 0.0f, 178, 128, 512, 512);
        }
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        ctx.method_51439(this.field_22793, this.method_25440(), x - this.field_22793.method_27525((class_5348)this.method_25440()) / 2, y - 82, 0xFFFFFF, false);
        this.renderPlayerInFrame(ctx, this.field_22789 / 2 - 90, this.field_22790 / 2 + 44, mouseX, mouseY);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        if (this.currentTab == 1) {
            // empty if block
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        this.breastSlider.save();
        this.xOffsetBoobSlider.save();
        this.yOffsetBoobSlider.save();
        this.zOffsetBoobSlider.save();
        this.cleavageSlider.save();
        this.floppySlider.save();
        this.bounceSlider.save();
        this.voicePitchSlider.save();
        return super.method_25406(mouseX, mouseY, state);
    }
}

