/*
 * Decompiled with CFR 0.152.
 */
package com.bouncingelf10.animatedLogo;

import com.bouncingelf10.animatedLogo.AnimatedLogo;
import net.fabricmc.loader.api.FabricLoader;

public class DarkLoadingScreenCompat {
    public static boolean isDarkLoadingScreenNotPresent() {
        return !FabricLoader.getInstance().isModLoaded("dark-loading-screen");
    }

    public static int getBarColor(int fallback) {
        if (DarkLoadingScreenCompat.isDarkLoadingScreenNotPresent()) {
            return fallback;
        }
        try {
            Class<?> configClass = Class.forName("io.github.a5b84.darkloadingscreen.config.Config");
            Object config = configClass.getMethod("read", new Class[0]).invoke(null, new Object[0]);
            return configClass.getField("bar").getInt(config);
        }
        catch (Exception e) {
            AnimatedLogo.LOGGER.error("Failed to access Dark Loading Screen config", (Throwable)e);
            return fallback;
        }
    }

    public static int getBorderColor(int fallback) {
        if (DarkLoadingScreenCompat.isDarkLoadingScreenNotPresent()) {
            return fallback;
        }
        try {
            Class<?> configClass = Class.forName("io.github.a5b84.darkloadingscreen.config.Config");
            Object config = configClass.getMethod("read", new Class[0]).invoke(null, new Object[0]);
            return configClass.getField("border").getInt(config);
        }
        catch (Exception e) {
            AnimatedLogo.LOGGER.error("Failed to access Dark Loading Screen config", (Throwable)e);
            return fallback;
        }
    }

    public static int getLogoColor(int fallback) {
        if (DarkLoadingScreenCompat.isDarkLoadingScreenNotPresent()) {
            return fallback;
        }
        try {
            Class<?> configClass = Class.forName("io.github.a5b84.darkloadingscreen.config.Config");
            Object config = configClass.getMethod("read", new Class[0]).invoke(null, new Object[0]);
            return configClass.getField("logo").getInt(config);
        }
        catch (Exception e) {
            AnimatedLogo.LOGGER.error("Failed to access Dark Loading Screen config", (Throwable)e);
            return fallback;
        }
    }
}

