/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.parser.ast;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.util.ExprBytesUtils;
import com.zigythebird.playeranim.lib.mochafloats.util.network.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class BinaryExpression
implements Expression {
    private final Op op;
    private Expression left;
    private Expression right;

    public BinaryExpression(ByteBuf buf) {
        this(ProtocolUtils.readEnum(Op.class, buf), ExprBytesUtils.readExpression(buf), ExprBytesUtils.readExpression(buf));
    }

    public BinaryExpression(@NotNull Op op, @NotNull Expression left, @NotNull Expression right) {
        this.op = Objects.requireNonNull(op, "op");
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    @NotNull
    public Op op() {
        return this.op;
    }

    @NotNull
    public Expression left() {
        return this.left;
    }

    public void left(@NotNull Expression left) {
        this.left = Objects.requireNonNull(left, "left");
    }

    @NotNull
    public Expression right() {
        return this.right;
    }

    public void right(@NotNull Expression right) {
        this.right = Objects.requireNonNull(right, "right");
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitBinary(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ProtocolUtils.writeEnum(this.op(), buf);
        ExprBytesUtils.writeExpression(this.left(), buf);
        ExprBytesUtils.writeExpression(this.right(), buf);
    }

    public String toString() {
        return String.format("%s%s%s", this.left, this.op.toString(), this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        if (this.op != that.op) {
            return false;
        }
        if (!this.left.equals(that.left)) {
            return false;
        }
        return this.right.equals(that.right);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = 31 * result + this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        return result;
    }

    public static enum Op {
        AND("&&", 300),
        OR("||", 200),
        LT("<", 700),
        LTE("<=", 700),
        GT(">", 700),
        GTE(">=", 700),
        ADD("+", 900),
        SUB("-", 900),
        MUL("*", 1000),
        DIV("/", 1000),
        ARROW("->", 2000),
        NULL_COALESCE("??", 2),
        ASSIGN("=", 1),
        CONDITIONAL("?", 1),
        EQ("==", 500),
        NEQ("!=", 500);

        private final String string;
        private final int precedence;

        private Op(String string2, int precedence) {
            this.string = string2;
            this.precedence = precedence;
        }

        @ApiStatus.Internal
        public int precedence() {
            return this.precedence;
        }

        public String toString() {
            return this.string;
        }
    }
}

