/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget.preview.elemets;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.PlayerPreview;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7919;

public abstract class PlayerChooseElement
extends PlayerPreview
implements IChooseElement {
    protected final AbstractFastChooseWidget parent;
    protected final int id;

    public PlayerChooseElement(AbstractFastChooseWidget parent, GameProfile profile, int id) {
        super(profile, 0, 0, 0, 0, false);
        this.player.emotecraft$getEmote().muteNbs = true;
        this.parent = parent;
        this.id = id;
        this.tick();
    }

    protected abstract void updateRectangle();

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.field_22762 && this.parent.controller.doHoverPart(this);
        this.updateRectangle();
        if (this.method_25367()) {
            this.renderHover(guiGraphics);
        }
        EmoteHolder emoteHolder = this.getEmote();
        super.method_48579(guiGraphics, this.method_46426() + this.method_25368() / 2, this.method_46427() + this.method_25364() / 2, partialTick);
        if (this.method_25367() && emoteHolder != null) {
            this.method_47400(class_7919.method_47407((class_2561)emoteHolder.name));
            this.method_47402(Duration.ZERO);
        } else {
            this.method_47400(null);
        }
    }

    protected abstract void renderHover(class_332 var1);

    @Override
    public void removed() {
        this.player.stopEmote();
    }

    @Override
    public boolean hasEmote() {
        return PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] != null;
    }

    @Override
    public EmoteHolder getEmote() {
        UUID uuid = PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id];
        if (uuid != null) {
            EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
            if (emote == null && this.parent.controller.doesShowInvalid()) {
                emote = new EmoteHolder.Empty(uuid);
            }
            return emote;
        }
        return null;
    }

    @Override
    public void clearEmote() {
        this.setEmote(null);
    }

    @Override
    public void setEmote(EmoteHolder emote) {
        PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] = emote == null ? null : emote.getUuid();
    }

    @Override
    public void tick() {
        EmoteHolder holder = this.getEmote();
        float previewTick = holder == null ? 1.0f : PlayerChooseElement.calculatePreviewTick(holder.getEmote());
        boolean shouldPlayAgain = holder == null || holder.getEmote().loopType().shouldPlayAgain(null, holder.getEmote());
        boolean updated = this.playAnimation(holder == null ? null : holder.getEmote(), shouldPlayAgain ? Animation.LoopType.DEFAULT : Animation.LoopType.LOOP, true, previewTick);
        super.pause(!updated && !this.method_25367());
        if (updated || this.method_25367()) {
            super.tick();
        }
    }

    protected static float calculatePreviewTick(Animation animation) {
        float returnToTick;
        ExtraAnimationData data = animation.data();
        if (data.has("previewTick")) {
            return ((Float)data.getRaw("previewTick")).floatValue();
        }
        if (animation.loopType().shouldPlayAgain(null, animation) && (returnToTick = animation.loopType().restartFromTick(null, animation)) > 0.0f) {
            return (animation.length() - returnToTick) / 2.0f;
        }
        return animation.length() / 2.0f;
    }

    protected boolean method_25351(int button) {
        return this.parent.controller.isValidClickButton(button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return this.parent.controller.onClick(this, button);
        }
        return false;
    }

    @Override
    public void method_25354(class_1144 handler) {
        if (!this.parent.controller.doHoverPart(this)) {
            return;
        }
        PlayerChooseElement.method_62888((class_1144)handler);
    }
}

