/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.UUID;
import javax.crypto.SecretKey;
import ru.dimaskama.webcam.net.Encryption;
import ru.dimaskama.webcam.server.PlayerState;
import ru.dimaskama.webcam.server.S2CEncodedPacket;

public class EncryptOutboundS2CHandler
extends ChannelOutboundHandlerAdapter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        byte[] encrypted;
        InetSocketAddress address;
        PlayerState encoded;
        PlayerState target;
        block7: {
            if (!(msg instanceof S2CEncodedPacket)) {
                ctx.write(msg);
                return;
            }
            S2CEncodedPacket s2CEncodedPacket = (S2CEncodedPacket)msg;
            try {
                PlayerState playerState;
                target = playerState = s2CEncodedPacket.target();
                encoded = playerState = s2CEncodedPacket.buf();
                address = target.getSocketAddress();
                if (address != null) break block7;
                throw new IllegalStateException("Player has not sent packets yet");
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        SecretKey secretKey = target.getSecretAsKey();
        if (encoded.hasArray()) {
            encrypted = Encryption.encrypt(encoded.array(), encoded.arrayOffset() + encoded.readerIndex(), encoded.readableBytes(), secretKey);
        } else {
            byte[] array = new byte[encoded.readableBytes()];
            encoded.readBytes(array);
            encrypted = Encryption.encrypt(array, 0, array.length, secretKey);
        }
        UUID uuid = target.getUuid();
        ByteBuf buf = ctx.alloc().buffer(17 + encrypted.length);
        try {
            buf.writeByte(-18).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits()).writeBytes(encrypted);
            ctx.write((Object)new DatagramPacket(buf, address));
            return;
        }
        catch (Exception e) {
            buf.release();
            throw e;
        }
    }
}

