/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import ru.dimaskama.webcam.config.JsonConfig;

public record SyncedServerConfig(int imageDimension, int mtu, int bitrate) {
    public static final int MIN_IMAGE_DIMENSION = 16;
    public static final int MAX_IMAGE_DIMENSION = 1440;
    public static final int MIN_MTU = 128;
    public static final int MAX_MTU = 2048;
    public static final int MIN_BITRATE = 10;
    public static final int MAX_BITRATE = 10000;
    public static final Codec<SyncedServerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)JsonConfig.defaultedField(Codec.intRange((int)16, (int)1440), "image_dimension", () -> 360).forGetter(SyncedServerConfig::imageDimension), (App)JsonConfig.defaultedField(Codec.intRange((int)128, (int)2048), "mtu", () -> 1100).forGetter(SyncedServerConfig::mtu), (App)JsonConfig.defaultedField(Codec.intRange((int)10, (int)10000), "bitrate", () -> 500).forGetter(SyncedServerConfig::bitrate)).apply((Applicative)instance, SyncedServerConfig::new));

    public SyncedServerConfig() {
        this(360, 1100, 500);
    }

    public SyncedServerConfig(ByteBuf buf) {
        this(buf.readShort(), buf.readShort(), buf.readInt());
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeShort(this.imageDimension).writeShort(this.mtu).writeInt(this.bitrate);
    }

    public SyncedServerConfig withImageDimension(int imageDimension) {
        return new SyncedServerConfig(imageDimension, this.mtu, this.bitrate);
    }

    public SyncedServerConfig withMtu(int mtu) {
        return new SyncedServerConfig(this.imageDimension, mtu, this.bitrate);
    }

    public SyncedServerConfig withBitrate(int bitrate) {
        return new SyncedServerConfig(this.imageDimension, this.mtu, bitrate);
    }
}

