/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.client.DisplayingVideo;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.net.NalUnit;
import ru.dimaskama.webcam.net.VideoSource;

public class DisplayingVideoManager {
    public static final DisplayingVideoManager INSTANCE = new DisplayingVideoManager();
    private final Map<UUID, DisplayingVideo> uuidToVideo = new ConcurrentHashMap<UUID, DisplayingVideo>();
    private volatile boolean viewPermission = true;
    private long minecraftTickCount;

    public void setViewPermission(boolean view) {
        boolean prevView = this.viewPermission;
        this.viewPermission = view;
        if (prevView && !view) {
            this.clear();
        }
    }

    public boolean hasViewPermission() {
        return this.viewPermission;
    }

    public VideoPacketResponse onVideoPacket(VideoSource source, NalUnit nal) {
        if (this.viewPermission) {
            if (WebcamModClient.CONFIG.getData().showWebcams()) {
                if (!WebcamModClient.BLOCKED_SOURCES.getData().contains(source.getUuid())) {
                    DisplayingVideo displayingVideo = this.uuidToVideo.computeIfAbsent(source.getUuid(), DisplayingVideo::new);
                    displayingVideo.onVideoPacket(this.minecraftTickCount, source, nal);
                    return VideoPacketResponse.ACCEPTED;
                }
                return VideoPacketResponse.SOURCE_IS_BLOCKED;
            }
            return VideoPacketResponse.WEBCAMS_ARE_DISABLED;
        }
        return VideoPacketResponse.NO_PERMISSION;
    }

    @Nullable
    public DisplayingVideo get(UUID sourceUuid) {
        return this.uuidToVideo.get(sourceUuid);
    }

    public void remove(UUID sourceUuid) {
        DisplayingVideo displayingVideo = this.uuidToVideo.remove(sourceUuid);
        if (displayingVideo != null) {
            displayingVideo.close();
        }
    }

    public void forEach(Consumer<DisplayingVideo> consumer) {
        this.uuidToVideo.values().forEach(consumer);
    }

    public void clear() {
        class_310.method_1551().execute(() -> this.uuidToVideo.values().removeIf(displayingVideo -> {
            displayingVideo.close();
            return true;
        }));
    }

    public void levelTick() {
        long time = this.minecraftTickCount++;
        this.uuidToVideo.values().removeIf(displayingVideo -> {
            if (time - displayingVideo.getLastChunkTime() > 100L) {
                displayingVideo.close();
                Webcam.getLogger().info("Removing displaying video " + String.valueOf(displayingVideo.getUuid()) + " as it was inactive for 5s");
                return true;
            }
            return false;
        });
    }

    public static enum VideoPacketResponse {
        ACCEPTED,
        NO_PERMISSION,
        WEBCAMS_ARE_DISABLED,
        SOURCE_IS_BLOCKED;

    }
}

