/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import com.mojang.util.UndashedUuid;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import ru.dimaskama.javah264.DecodeResult;
import ru.dimaskama.javah264.H264Decoder;
import ru.dimaskama.webcam.WebcamMod;
import ru.dimaskama.webcam.client.VideoPacketBuffer;
import ru.dimaskama.webcam.client.WebcamModClient;
import ru.dimaskama.webcam.client.cap.ImageUtil;
import ru.dimaskama.webcam.net.NalUnit;
import ru.dimaskama.webcam.net.VideoSource;

public class DisplayingVideo {
    private final UUID uuid;
    private final class_2960 textureId;
    private final H264Decoder decoder;
    private final VideoPacketBuffer buffer = new VideoPacketBuffer(WebcamModClient.CONFIG.getData().packetBufferSize(), this::acceptVideoPacket);
    private final AtomicReference<DecodeResult> newFrame = new AtomicReference();
    private volatile VideoSource lastSource;
    private long lastChunkTime;
    private class_1011 image;
    private class_1043 texture;

    public DisplayingVideo(UUID uuid) {
        this.uuid = uuid;
        this.textureId = WebcamMod.id("webcam_" + UndashedUuid.toString((UUID)uuid));
        try {
            this.decoder = H264Decoder.builder().flushBehavior(H264Decoder.FlushBehavior.NoFlush).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create H264Decoder", e);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public RenderData getRenderData() {
        DecodeResult newFrame = this.newFrame.getAndSet(null);
        if (newFrame != null) {
            class_1011 image = ImageUtil.createNativeImage(this.image, newFrame.getWidth(), newFrame.getHeight(), newFrame.getImage());
            if (image != this.image) {
                if (this.texture != null) {
                    this.texture.close();
                }
                this.texture = new class_1043(() -> ((class_2960)this.textureId).method_12832(), image);
                this.texture.method_4527(true, false);
                class_310.method_1551().method_1531().method_4616(this.textureId, (class_1044)this.texture);
            } else {
                this.texture.method_4524();
            }
            this.image = image;
        }
        return this.texture != null ? new RenderData(this.lastSource, this.textureId) : null;
    }

    private static boolean sizeEquals(class_1011 image1, class_1011 image2) {
        return image1.method_4307() == image2.method_4307() && image1.method_4323() == image2.method_4323();
    }

    public long getLastChunkTime() {
        return this.lastChunkTime;
    }

    public void onVideoPacket(long time, VideoSource source, NalUnit nalUnit) {
        this.lastChunkTime = time;
        this.buffer.receivePacket(nalUnit.sequenceNumber(), nalUnit.data());
        this.lastSource = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptVideoPacket(byte[] nal) {
        DecodeResult decoded;
        H264Decoder h264Decoder = this.decoder;
        synchronized (h264Decoder) {
            decoded = this.decoder.decodeRGBA(nal);
        }
        if (decoded != null) {
            this.newFrame.set(decoded);
        }
    }

    public void close() {
        class_310.method_1551().method_1531().method_4615(this.textureId);
    }

    public record RenderData(VideoSource source, class_2960 textureId) {
    }
}

