#include "/lib/all_the_libs.glsl"
#include "/generic/water.glsl"
in vec2 texcoord;
in vec4 glcolor;

flat in vec3 Normal;
flat in uint Material;

in vec3 PlayerPos;

#ifdef RSM
    /* DRAWBUFFERS:01 */
#else
    /* DRAWBUFFERS:0 */
#endif
layout(location = 0) out vec4 Color;
#ifdef RSM
    layout(location = 1) out vec4 ShadowNormal;
#endif

void main() {
    Color = texture(texture, texcoord) * glcolor;
    if (Color.a < 0.1) {
        discard;
        return;
    }

    if (renderStage == MC_RENDER_STAGE_ENTITIES) { // Stop entities from contributing to RSM because it ruins temporal stability
        Color.rgb = vec3(0);
    } 

    Color.rgb = srgb_linear(Color.rgb);

    #ifdef RSM
        ShadowNormal.rg = encodeUnitVector(Normal) * 0.5 + 0.5;
    #endif
}
