#include "/lib/all_the_libs.glsl"

const ivec3 workGroups = ivec3(4, 4, 1);

layout(local_size_x = 8, local_size_y = 8) in;

void calc_aerial_perspective(vec3 Origin, vec3 Dir, vec2 FragCoord) {
    const float STEP_COUNT = 32;
    const float MAX_DISTANCE = 20000;

    vec3 End = Origin + Dir * MAX_DISTANCE;

    vec3 Step = (End - Origin) / STEP_COUNT;
    float StepL = length(Step);

    vec3 Pa_P = vec3(0);
    vec3 Sum = vec3(0);
    vec3 Throughput = vec3(1);

    vec3 SunDir = normalize(vec3(1, view_player(sunPosN).y, 0));
    float VdotLSun = dot(Dir, SunDir);
    float VdotLMoon = dot(Dir, -SunDir);

    vec4 Phase = vec4(ISOTROPIC_PHASE);
    Phase = vec4(
        rayleigh_phase(VdotLSun),
        cs_phase(VdotLSun),
        rayleigh_phase(VdotLMoon),
        cs_phase(VdotLMoon)
    );

    imageStore(atm_aerial_perspective, ivec3(FragCoord, 0), vec4(0, 0, 0, 1));
    
    for(int i = 1; i < STEP_COUNT; i++) {
        vec3 P = Origin + Step * i;
        float Len = length(P) - EarthRad;

        vec3 Pa_P_Sample = all_densities(Len) * StepL;
        Pa_P += Pa_P_Sample.x * BETA_R + Pa_P_Sample.y * (BETA_M + BETA_M_A) + Pa_P_Sample.z * BETA_O_A;

        vec3 RayD = BETA_R * density_exp(Len, Hr);
        float MieD = BETA_M * density_exp(Len, Hm);

        vec3 Pa_PcSun = retrieve_transmittance_sun(Len, dot(SunDir, vec3(0, 1, 0)));
        vec3 TransmittanceSun = exp(-Pa_P) * Pa_PcSun;
        vec3 ScatteringSample = (RayD * Phase.x + MieD * Phase.y) * TransmittanceSun * DayAmbientColor;

        vec3 Pa_PcMoon = retrieve_transmittance_sun(Len, dot(-SunDir, vec3(0, 1, 0)));
        vec3 TransmittanceMoon = exp(-Pa_P) * Pa_PcMoon;
        ScatteringSample += (RayD * Phase.z + MieD * Phase.w) * TransmittanceMoon * NightAmbientColor;

        Sum += ScatteringSample;
        Throughput *= exp(-Pa_P_Sample);

        imageStore(atm_aerial_perspective, ivec3(FragCoord, i), vec4(Sum * StepL * ISOTROPIC_PHASE, dot(Throughput, vec3(0.33))));
    }
}

void main() {
    vec2 FragCoord = gl_GlobalInvocationID.xy;

    float u = FragCoord.x / 32;
    float v = FragCoord.y / 32;

    float Height = EarthRad + cameraPosition.y * 5;
    vec3 Origin = vec3(0, Height, 0);
    vec3 Dir = normalize(view_player(screen_view(vec3(u, v, 1), false)));

    // calc_aerial_perspective(Origin, Dir, FragCoord);
}