#include "/lib/all_the_libs.glsl"
#include "/generic/post/cas.fsh"
in vec2 texcoord;

#include "/generic/post/taa.glsl"

vec3 apply_vignette(vec3 Color, vec2 Pos) {
    Pos = Pos - 0.5;
    float Strength = len2(Pos);
    Strength = pow(Strength, 2 - VIGNETTE_FALLOFF);
    Color *= 1 - min(Strength, 1);
    return Color;
}

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;


void main() {
    #if AA_MODE != 0
	Color.rgb = CAS(colortex0, texcoord);
    #else
    Color.rgb = textureLod(colortex0, texcoord, 0).rgb;
    #endif

    
    
    // These tonemaps already have the conversion built in
    #if TONEMAP_OPERATOR != 1 && TONEMAP_OPERATOR != 3
        Color.rgb = linear_srgb(Color.rgb);
    #endif

    #ifdef FILM_GRAIN
    Color.rgb = film_grain(Color.rgb, gl_FragCoord.xy);
    #endif

    Color.rgb = apply_vibrance(Color.rgb, VIBRANCE);
    Color.rgb = apply_saturation(Color.rgb, SATURATION);
    Color.rgb = apply_contrast(Color.rgb, CONTRAST);

    #ifdef VIGNETTE
        Color.rgb = apply_vignette(Color.rgb, texcoord);
    #endif

    Color.rgb += (bayer8(gl_FragCoord.xy) - 0.5) / 255 * 2;

    // Color.rgb = texture(atm_skyview_sampler, texcoord).rgb;
    // Color.rgb = texiture(atm_transmittance_sampler, texcoord).rgb;
    // Color.rgb = texture(atm_aerial_perspective_sampler, vec3(texcoord, 0.01)).rgb;
    // Color.rgb = texture(atm_multi_scattering_sampler, texcoord).rgb * 50;
}
