#include "/lib/all_the_libs.glsl"
// Clouds

#include "/generic/sky.glsl"
#include "/generic/clouds.glsl"

#ifdef CLOUDS
const vec2 workGroupsRender = vec2(CLOUD_RES_SCALING, CLOUD_RES_SCALING);
#else
const vec2 workGroupsRender = vec2(0, 0);
#endif

layout(local_size_x = 16, local_size_y = 16) in;
void main() {
    const int CLOUD_RES_SCALING_INV = int(1 / CLOUD_RES_SCALING);
    vec2 FragPos = gl_GlobalInvocationID.xy * CLOUD_RES_SCALING_INV + ivec2(frameCounter * CLOUD_RES_SCALING, frameCounter) % CLOUD_RES_SCALING_INV;
    vec2 texcoord = FragPos * resolutionInv;
    float Depth = max_depth_4x4(texcoord);

    vec4 CloudData = vec4(0, 0, 0, 0);

    vec3 ScreenPos = vec3(texcoord, Depth);
    vec3 ViewPos = screen_view(ScreenPos, true);
    vec3 ViewPosN = normalize(ViewPos);
    vec3 PlayerPos = view_player(ViewPos);
    vec3 PlayerPosN = normalize(PlayerPos);

    float _DepthCloud = Depth;
    CloudData = get_clouds(PlayerPos, PlayerPosN, 16, cameraPosition, true, FragPos, _DepthCloud);

    // Transmittance should default to 1
    CloudData.a = 1 - CloudData.a;
    imageStore(image0, ivec2(FragPos), CloudData);
    imageStore(image1, ivec2(gl_GlobalInvocationID.xy), vec4(_DepthCloud, 0, 0, 0));
}
