#include "/lib/all_the_libs.glsl"

flat in vec3 LightColorDirect; // This needs to be initialized in the vertex stage of the pass

#include "/generic/water.glsl"
#include "/generic/shadow/main.glsl"
#include "/generic/shadow/rsm.glsl"
#include "/generic/shadow/vl.glsl"
#include "/generic/sky.glsl"
#include "/generic/fog.glsl"

in vec2 texcoord;

flat in vec3 LightPosFlare;

float get_flare_dist(vec2 Coord, const float SCALE) {
    vec2 d = Coord + LightPosFlare.xy * SCALE;
    d.x *= aspectRatio;
    return length(d);
}

float circle_flare(vec2 Coord, const float SCALE, const float SIZE) {
    float Dist = get_flare_dist(Coord, SCALE);

    return pow4(clamp(1 - Dist / SIZE, 0, 1));
}

float ring_flare(vec2 Coord, const float SCALE, const float SIZE) {
    float Dist = get_flare_dist(Coord, SCALE);

    Dist = abs(SIZE - Dist);
    return pow4(clamp(1 - Dist / SIZE, 0, 1));
}

float hollow_flare(vec2 Coord, const float SCALE, const float SIZE) {
    float Dist = get_flare_dist(Coord, SCALE);

    Dist /= SIZE;
    return (1 - smoothstep(0.8, 1, Dist)) * Dist;
}

vec3 lens_flare() {
    if(dataBuf.SunVisibility < 1e-6) return vec3(0);

    vec2 Coord = texcoord - 0.5;

    vec3 Color = vec3(0);

    // Streaks
    vec2 d = LightPosFlare.xy - Coord;
    d.x *= aspectRatio;
    d = abs(d);
    float Falloff = 1 - smoothstep(0.0, 0.5, d.x);
    Color += (1-smoothstep(0.0, 0.02, d.y)) * Falloff * 0.005;
    
    // float ang = atan(d.x, d.y);
    // float Dist = length(d);
    // float Noise = texture(noisetex, vec2(sin(ang*0.5+LightPosFlare.x)*2 - cos(ang+LightPosFlare.y)*1, 0)/255).r;
    // Color.rgb += pow4(sin(Noise)) * pow(max(0, 1-Dist), 32);
    

    // Circle things
    Color += circle_flare(Coord, -0.25, 0.02) * 0.03;

    Color.r += circle_flare(Coord, 0.68, 0.07) * 0.01;
    Color.g += circle_flare(Coord, 0.7, 0.07) * 0.01;
    Color.b += circle_flare(Coord, 0.72, 0.07) * 0.04;

    Color.r += circle_flare(Coord, 0.92, 0.07) * 0.005;
    Color.b += circle_flare(Coord, 0.94, 0.07) * 0.02;

    // Other circle things
    Color += hollow_flare(Coord, -0.1, 0.03) * 0.002;

    Color.r += hollow_flare(Coord, 0.57, 0.1) * 0.001;
    Color.g += hollow_flare(Coord, 0.58, 0.1) * 0.002;
    Color.b += hollow_flare(Coord, 0.59, 0.1) * 0.004;

    Color.g += hollow_flare(Coord, 1.0, 0.2) * 0.002;
    Color.b += hollow_flare(Coord, 1.02, 0.2) * 0.006;

    // Big outer ring
    Color.b += ring_flare(Coord, 2.0, 0.5) * 0.008;

    // Halo around the sun
    Color.r += ring_flare(Coord, -1, 0.15) * 0.002;
    Color.g += ring_flare(Coord, -1, 0.16) * 0.003;
    Color.b += ring_flare(Coord, -1, 0.17) * 0.006;
    
    return Color * dataBuf.SunVisibility * LightColorDirect;
}

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;

void main() {
    Color = texture(colortex0, texcoord);
    float Depth = texture(depthtex0, texcoord).x;
    vec3 ScreenPos = vec3(texcoord, Depth);
    vec3 ViewPos = screen_view(ScreenPos, true);
    vec3 ViewPosN = normalize(ViewPos);
    vec3 PlayerPos = view_player(ViewPos);
    vec3 PlayerPosN = normalize(PlayerPos);

    if (Depth > 0.56) {
        if (Depth < 1) {
            vec4 Data = texture(colortex1, texcoord);
            vec2 UnpackX = unpackUnorm2x8(Data.x);
            vec2 UnpackY = unpackUnorm2x8(Data.y);

            #ifdef SPATIAL_DENOISING
                vec4 GISpatial = gi_denoise(colortex3, texcoord, vec2(0, 1), Depth);
            #endif

            float Material = UnpackY.y * 255;

            vec3 Albedo = vec3(UnpackX, UnpackY.x);
            Albedo.rgb = srgb_linear(Albedo.rgb);

            #ifdef GTAO
                Color.rgb *= 1 - GISpatial.a;
            #endif
            #ifdef RSM
                Color.rgb += GISpatial.rgb * Albedo;
            #endif

            // float z = length(PlayerPos) / 20000 * AERIAL_PERSPECTIVE_SCALE;
            // vec4 AtmData = texture(atm_aerial_perspective_sampler, vec3(texcoord, z));
            // Color.rgb *= AtmData.a;
            // Color.rgb += AtmData.rgb;
        }

        vec3 SkyColor = get_sky(ViewPosN, false, PlayerPosN.y);
        Color.rgb = get_fog_main(PlayerPos, Color.rgb, Depth, SkyColor);

        Color.rgb = do_vl(vec3(0), PlayerPos, PlayerPosN, Color.rgb, ScreenPos, VL_SAMPLES, VL_OVERWORLD_RT, VL_OVERWORLD_RT, VL_OVERWORLD_DETAIL);
    }

    Color.rgb = purkinje_effect(Color.rgb);

    #if (defined LENS_FLARE) && (defined DIMENSION_OVERWORLD)
    Color.rgb += lens_flare() * LENS_FLARE_STRENGTH;
    #endif

    // This needs to be cleared before bloom
    imageStore(image0, ivec2(gl_FragCoord.xy), vec4(0));
}
