#include "/lib/all_the_libs.glsl"

layout(local_size_x = 4, local_size_y = 16) in;

ivec2 SAMPLE_OFFSET = ivec2(448 * aspectRatio + 30, 0);
ivec2 OFFSET = ivec2(480 * aspectRatio + 40, 0);
#include "/generic/post/bloom.glsl"

void main() {
    ivec2 GlobalPos = ivec2(gl_GlobalInvocationID.xy);

    vec2 SamplePos = (GlobalPos * 2 + SAMPLE_OFFSET) * resolutionInv;
    vec3 Color = read_bloom_downscale(SamplePos, true);
    write_bloom(GlobalPos + OFFSET, Color, false);
}
