#include "/lib/all_the_libs.glsl"

in vec2 texcoord;

#include "/generic/post/bloom.glsl"

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 Color;

void main() {
    Color = texture(colortex0, texcoord);

    #ifdef BLOOM
    float Offset = 0;
    vec3 FinalBloom = blur3x3(image0Sampler, 1 - texcoord * vec2(256 * aspectRatio, 256) * resolutionInv).rgb;

    Color.rgb += FinalBloom * clamp(BLOOM_STRENGTH, 0, 1);
    #endif
}
