#define q_off    0
#define q_toaster 1
#define q_low    2
#define q_medium 3
#define q_high   4
#define q_ultra  5

#define p_INDIRECT_LIGHTING q_high // [q_off q_low q_medium q_high]

#if p_INDIRECT_LIGHTING == q_off
#elif p_INDIRECT_LIGHTING == q_low
    #define SSAO
#elif p_INDIRECT_LIGHTING == q_medium
    #define GTAO
#elif p_INDIRECT_LIGHTING == q_high
    #define GTAO
    #define RSM
#endif

#define p_SHADOWS q_high // [q_low q_medium q_high q_ultra]

#if p_SHADOWS == q_low
    const int shadowMapResolution = 1024;
    const float shadowDistance = 128.0;
    const float entityShadowDistanceMul = 0;
    #define SHADOW_FILTER 1
#elif p_SHADOWS == q_medium
    const int shadowMapResolution = 2048;
    const float shadowDistance = 192.0;
    const float entityShadowDistanceMul = 0.25;
    #define SHADOW_FILTER 1
#elif p_SHADOWS == q_high
    const int shadowMapResolution = 2048;
    const float shadowDistance = 192.0;
    const float entityShadowDistanceMul = 0.25;
    #define SHADOW_FILTER 2
#elif p_SHADOWS == q_ultra
    const int shadowMapResolution = 3072;
    const float shadowDistance = 256.0;
    const float entityShadowDistanceMul = 0.25;
    #define SHADOW_FILTER 2
#endif

#define p_FOG q_high // [q_toaster q_low q_high q_ultra]

#if p_FOG == q_toaster
    const bool VL_OVERWORLD_RT = false;
    const bool VL_WATER_RT = false;
    const bool VL_OVERWORLD_DETAIL = false;
    const int VL_SAMPLES = 4;
#elif p_FOG == q_low
    const bool VL_OVERWORLD_RT = true;
    const bool VL_WATER_RT = false;
    const bool VL_OVERWORLD_DETAIL = false;
    const int VL_SAMPLES = 4;
#elif p_FOG == q_high
    const bool VL_OVERWORLD_RT = true;
    const bool VL_WATER_RT = true;
    const bool VL_OVERWORLD_DETAIL = true;
    const int VL_SAMPLES = 12;
#elif p_FOG == q_ultra
    const bool VL_OVERWORLD_RT = true;
    const bool VL_WATER_RT = true;
    const bool VL_OVERWORLD_DETAIL = true;
    const int VL_SAMPLES = 16;
#endif

#define p_MATERIALS 1 // [0 1 2]

#if p_MATERIALS == 0
#elif p_MATERIALS == 1
    #define PBR_NORMAL
    #define PBR_SPECULAR
    #define PBR_EMISSIVENESS
    #define PBR_SSS
#elif p_MATERIALS == 2
    #define PBR_NORMAL
    #define PBR_SPECULAR
    #define PBR_EMISSIVENESS
    #define PBR_SSS
    #define PBR_POM
    #define ROUGH_REFLECTIONS
#endif
