#include "/generic/gtao.glsl"

vec3 calc_lighting(Positions Pos, vec2 texcoord, vec3 Color, float Material, float PackSSS, float Emissiveness, vec2 Lightmap,
    vec3 Normal, vec3 FlatNormal, bool IsHand, out vec4 ShadowBuf) {

    Color += Color * Emissiveness * 2 * float(Emissiveness < 1);

    if (Material >= MATERIAL_TALL_PLANT_LOWER && Material <= MATERIAL_SHORT_PLANT) {
        Normal = gbufferModelView[1].xyz; // upDirection
    }
    float NdotL = dot(sLightPosN, Normal);

    Lightmap = pow4(Lightmap);

    if (IsHand) {
        // Prevents a strange rare lightleak
        NdotL *= Lightmap.y;
    }

    #ifdef DIMENSION_OVERWORLD
    vec3 SunA = dataBuf.AmbientColor; // Value written in prepare, in the data buffer
    
    SunA = mix(MinLight, SunA, Lightmap.y);
    #elif defined DIMENSION_NETHER
    // Fake lighting, to make things look less flat
    float NdotU = dot(Normal, gbufferModelView[1].xyz);
    vec3 FakeLavaLight = TorchlightColor * 0.05 * (-NdotU * 0.5 + 0.5);
    vec3 FakeAmbientLight = fogColor.rgb * 0.15 * (NdotU * 0.5 + 0.5);
    vec3 SunA = MinLight + FakeAmbientLight + FakeLavaLight;
    #else
    vec3 SunA = vec3(1);
    #endif

    vec3 OutColor = Color * (SunA + Lightmap.x * TorchlightColor);

    float SSSS = PackSSS;
    if (PackSSS < 64.0 / 255.0) {
        if (Material == MATERIAL_SSS_WEAK) SSSS = SSS_STRENGTH_WEAK;
        else if (Material >= MATERIAL_SSS_STRONG && Material <= MATERIAL_LEAVES) SSSS = SSS_STRENGTH_STRONG;
        else SSSS = 0;
    }
    bool DoSSS = SSSS > 0;

    vec3 SunDirect = vec3(0);
    bool IsMetal, IsHardcodedMetal;
    vec3 Shadow = vec3(0);
    mat2x3 F0 = get_reflectance(texcoord, Material, Color, IsMetal, IsHardcodedMetal);
    if (NdotL > 0 || DoSSS) {
        Shadow = get_shadow(Pos.Player, Pos.View, FlatNormal, Lightmap.y, DoSSS, ivec2(gl_FragCoord.xy));

        if (Shadow != vec3(0)) {
            vec3 LightColor;
            if (sunAngle < 0.5)
                LightColor = dataBuf.SunColor;
            else
                LightColor = dataBuf.MoonColor;

            float LHeight = sin(sunAngle * TAU); // to_player_pos(sunPosN).y;
            LightColor *= smoothstep(0, 0.05, abs(LHeight));

            SunDirect = Color / PI * max(0.1, float(!IsMetal));
            SunDirect *= LightColor * max(NdotL, 0);

            if (DoSSS) {
                SSSS = (1 - SSSS) * 5;

                float SSS = exp(-SSSS * abs(NdotL));
                float Phase = max(ISOTROPIC_PHASE, cs_phase(dot(Pos.ViewN, sLightPosN), 0.6));
                SunDirect += Color.rgb * LightColor * SSS * Phase;
            }
        }
    }
    OutColor = OutColor + SunDirect * Shadow;

    ShadowBuf.r = get_luminance(Shadow);

    return OutColor * max(0.33, float(!IsMetal));
}
