in Data {
    vec2 lmcoord;
    vec2 texcoord;
    vec4 glcolor;
    flat uint Material;
    flat mat3 TBN;
    vec3 ViewPos;
} DataIn;

/* DRAWBUFFERS:0125 */
layout(location = 0) out vec4 Albedo;
layout(location = 1) out vec4 buf1;
layout(location = 2) out vec4 buf2;
layout(location = 3) out vec4 Shadow;

void init_frag_translucent() {
    vec3 ScreenPos = gl_FragCoord.xyz * vec3(resolutionInv, 1);
    Positions Pos = get_positions(ScreenPos.xy, ScreenPos.z, false);
    
    #ifndef GBUFFERS_BASIC
        Albedo = DataIn.glcolor * texture(texture, DataIn.texcoord);
    #else
        Albedo = glcolor_flat;
    #endif

    if (Albedo.a < 0.1) {
        discard;
        return;
    }

    Albedo.rgb = srgb_linear(Albedo.rgb);

    Albedo.rgb *= texture(normals, DataIn.texcoord).b;

    #ifdef GBUFFERS_ENTITIES
    Albedo.rgb = mix(Albedo.rgb, entityColor.rgb, entityColor.a);
    #endif

    if (DataIn.Material == MATERIAL_WATER) {
        Albedo = vec4(0);
    }

    buf1.x = packUnorm2x8(Albedo.rg);
    buf1.y = packUnorm2x8(vec2(Albedo.b, float(DataIn.Material) / 255));

    buf1.z = packUnorm2x8(texture(specular, DataIn.texcoord).rg);

    vec3 PackNormal = get_normal(DataIn.texcoord);
    vec3 Normal = DataIn.TBN * PackNormal;
    if (DataIn.Material == MATERIAL_WATER) {
        vec3 WorldNormal = view_player(Normal);
        Normal = DataIn.TBN * get_water_normal(Pos.World, WorldNormal, Pos.View.z);
    }

    buf1.w = packUnorm2x8(encodeUnitVector(view_player(Normal)) * 0.5 + 0.5);

    vec2 Lightmap = DataIn.lmcoord + bayer8(gl_FragCoord.xy) / 255.0;

    buf2.x = packUnorm2x8(Lightmap);

    buf2.w = packUnorm2x8(encodeUnitVector(view_player(DataIn.TBN[2])) * 0.5 + 0.5);

    float PackSSS = get_sss(DataIn.texcoord);
    float Emissiveness = get_emissiveness(DataIn.texcoord);

    if (DataIn.Material != MATERIAL_WATER) {
        Albedo.rgb = calc_lighting(Pos, DataIn.texcoord, Albedo.rgb, DataIn.Material, PackSSS, Emissiveness, DataIn.lmcoord,
                Normal, DataIn.TBN[2], false, Shadow);
    }
    else {
        Shadow.r = get_shadow_unfiltered(Pos.Player, DataIn.TBN[2], DataIn.lmcoord.y);
    }
}
