in Data {
    vec2 lmcoord;
    vec2 texcoord;
    vec4 glcolor;
    flat uint Material;
    flat mat3 TBN;
    vec3 ViewPos;
} DataIn;

/* DRAWBUFFERS:12 */
layout(location = 0) out vec4 buf1;
layout(location = 1) out vec4 buf2;

void init_frag() {

    vec4 Albedo = DataIn.glcolor * texture(texture, DataIn.texcoord);
    if (Albedo.a < 0.1) {
        discard;
        return;
    }
    Albedo.rgb = pow(Albedo.rgb, vec3(2.2));
    Albedo.rgb *= DataIn.glcolor.a;
    Albedo.rgb *= texture(normals, DataIn.texcoord).b;
    Albedo.rgb = pow(Albedo.rgb, vec3(1 / 2.2));

    #ifdef GBUFFERS_ENTITIES
    Albedo.rgb = mix(Albedo.rgb, entityColor.rgb, entityColor.a);
    #endif

    buf1.x = packUnorm2x8(Albedo.rg);
    buf1.y = packUnorm2x8(vec2(Albedo.b, float(DataIn.Material) / 255));

    buf1.z = packUnorm2x8(texture(specular, DataIn.texcoord).rg);

    vec3 PackNormal = get_normal(DataIn.texcoord);
    vec3 Normal = DataIn.TBN * PackNormal;

    buf1.w = packUnorm2x8(encodeUnitVector(view_player(Normal)) * 0.5 + 0.5);

    vec2 Lightmap = DataIn.lmcoord + bayer8(gl_FragCoord.xy) / 255.0;

    buf2.x = packUnorm2x8(Lightmap);

    float PackSSS = get_sss(DataIn.texcoord);
    float Emissiveness = get_emissiveness(DataIn.texcoord);
    
    buf2.z = packUnorm2x8(vec2(PackSSS, Emissiveness));

    buf2.w = packUnorm2x8(encodeUnitVector(view_player(DataIn.TBN[2])) * 0.5 + 0.5);

}
