/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SerializableConfig {
    public final List<ConfigEntry<?>> basics = new ArrayList();
    public final List<ConfigEntry<?>> expert = new ArrayList();
    public static final int staticConfigVersion = 4;
    public int configVersion;
    public final ConfigEntry<Boolean> validateEmote = new ConfigEntry<Boolean>("validate", Boolean.valueOf(false), true, this.expert);
    public final ConfigEntry<Float> validThreshold = new FloatConfigEntry("validationThreshold", "validThreshold", Float.valueOf(8.0f), true, this.expert, "options.generic_value", 0.2f, 16.0f, 0.0f);
    public final ConfigEntry<Boolean> loadBuiltinEmotes = new ConfigEntry<Boolean>("loadbuiltin", "loadBuiltin", Boolean.valueOf(true), true, this.basics);
    public final ConfigEntry<Boolean> loadEmotesServerSide = new ConfigEntry<Boolean>("emotesFolderOnLogicalServer", false, true, this.expert, true);
    public final ConfigEntry<Boolean> enableQuark = new ConfigEntry<Boolean>("quark", "enablequark", Boolean.valueOf(false), true, this.basics);
    public final ConfigEntry<String> emotesDir = new ConfigEntry<String>("emotesDirectory", "emotes", false, this.expert, true);

    public void iterate(Consumer<ConfigEntry<?>> consumer) {
        this.basics.forEach(consumer);
        this.expert.forEach(consumer);
    }

    public SerializableConfig() {
        this.loadEmotesServerSide.set(true);
    }

    public static class ConfigEntry<T> {
        final String name;
        final String oldConfig;
        T value;
        final T defaultValue;
        public final boolean hasTooltip;
        final boolean isHidden;

        public ConfigEntry(String name, String oldconfig, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            this.name = name;
            this.oldConfig = oldconfig;
            this.hasTooltip = hasTooltip;
            this.defaultValue = defVal;
            this.value = defVal;
            collection.add(this);
            this.isHidden = hidden;
        }

        public ConfigEntry(String name, String oldconfig, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            this(name, oldconfig, defVal, hasTooltip, collection, false);
        }

        public ConfigEntry(String name, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            this(name, null, defVal, hasTooltip, collection);
        }

        public ConfigEntry(String name, T defVal, List<ConfigEntry<?>> collection, boolean hidden) {
            this(name, null, defVal, false, collection, hidden);
        }

        public ConfigEntry(String name, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            this(name, null, defVal, hasTooltip, collection, hidden);
        }

        public T get() {
            return this.value;
        }

        public void set(T newValue) {
            this.value = newValue;
        }

        public String getName() {
            return this.name;
        }

        public String getOldConfigName() {
            return this.oldConfig;
        }

        public void resetToDefault() {
            this.value = this.defaultValue;
        }

        public boolean showEntry() {
            return !this.isHidden;
        }
    }

    public static class FloatConfigEntry
    extends ConfigEntry<Float> {
        private final String formatKey;
        public final float min;
        public final float max;
        public final float step;

        public FloatConfigEntry(String name, String oldconfig, Float defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, String formatKey, float min, float max, float step) {
            super(name, oldconfig, defVal, hasTooltip, collection);
            this.formatKey = formatKey;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public FloatConfigEntry(String name, Float defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, String formatKey, float min, float step, float max) {
            this(name, null, defVal, hasTooltip, collection, formatKey, min, max, step);
        }

        public String getFormatKey() {
            return this.formatKey;
        }

        public double getConfigVal() {
            return Math.sqrt(((Float)this.get()).floatValue());
        }

        public void setConfigVal(double newVal) {
            this.set(Float.valueOf((float)Math.pow(newVal, 2.0)));
        }

        public double getTextVal() {
            return ((Float)this.get()).floatValue();
        }
    }

    public static class ListConfigEntry<T>
    extends ConfigEntry<List<T>> {
        public ListConfigEntry(String name, String oldconfig, List<T> defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, oldconfig, defVal, hasTooltip, collection, hidden);
        }

        public ListConfigEntry(String name, String oldconfig, List<T> defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            super(name, oldconfig, defVal, hasTooltip, collection);
        }

        public ListConfigEntry(String name, List<T> defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            super(name, defVal, hasTooltip, collection);
        }

        public ListConfigEntry(String name, List<T> defVal, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, defVal, collection, hidden);
        }

        public ListConfigEntry(String name, List<T> defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, defVal, hasTooltip, collection, hidden);
        }
    }
}

