/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.net.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.dimaskama.webcam.net.KnownSource;
import ru.dimaskama.webcam.net.packet.Packet;
import ru.dimaskama.webcam.net.packet.PacketType;

public record KnownSourcesS2CPacket(List<KnownSource> sources) implements Packet
{
    public KnownSourcesS2CPacket(ByteBuf buf) {
        this(KnownSourcesS2CPacket.decodeSources(buf));
    }

    private static List<KnownSource> decodeSources(ByteBuf buf) {
        int size = buf.readShort() & 0xFFFF;
        ArrayList<KnownSource> sources = new ArrayList<KnownSource>(size);
        for (int i = 0; i < size; ++i) {
            sources.add(new KnownSource(buf));
        }
        return sources;
    }

    public static List<KnownSourcesS2CPacket> split(int mtu, Iterator<KnownSource> iterator) {
        ArrayList<KnownSourcesS2CPacket> packets = new ArrayList<KnownSourcesS2CPacket>();
        ArrayList<KnownSource> sources = new ArrayList<KnownSource>();
        int packetSize = 2;
        while (iterator.hasNext()) {
            KnownSource source = iterator.next();
            int sourceSize = source.getSize();
            if (packetSize + sourceSize >= mtu && !sources.isEmpty()) {
                packets.add(new KnownSourcesS2CPacket(sources));
                sources = new ArrayList();
                packetSize = 2;
            }
            packetSize += sourceSize;
            sources.add(source);
        }
        if (!sources.isEmpty()) {
            packets.add(new KnownSourcesS2CPacket(sources));
        }
        return packets;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        buf.writeShort(this.sources.size());
        for (KnownSource source : this.sources) {
            source.writeBytes(buf);
        }
    }

    public PacketType<KnownSourcesS2CPacket> getType() {
        return PacketType.KNOWN_SOURCES_S2C;
    }

    @Override
    public int getEstimatedSize() {
        return 2 + this.sources.size() * 17;
    }
}

