/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.message;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import ru.dimaskama.webcam.message.BufUtils;
import ru.dimaskama.webcam.message.Channel;
import ru.dimaskama.webcam.message.Message;

public record SecretMessage(UUID secret, int serverPort, int keepAlivePeriod, String host) implements Message
{
    public SecretMessage(ByteBuf buf) {
        this(new UUID(buf.readLong(), buf.readLong()), buf.readShort() & 0xFFFF, buf.readInt(), BufUtils.readUtf8(buf));
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        buf.writeLong(this.secret.getMostSignificantBits()).writeLong(this.secret.getLeastSignificantBits());
        buf.writeShort(this.serverPort);
        buf.writeInt(this.keepAlivePeriod);
        BufUtils.writeUtf8(buf, this.host);
    }

    public Channel<SecretMessage> getChannel() {
        return Channel.SECRET;
    }
}

