/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.command;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import ru.dimaskama.webcam.Webcam;
import ru.dimaskama.webcam.config.ServerConfig;
import ru.dimaskama.webcam.config.VideoDisplayShape;
import ru.dimaskama.webcam.net.packet.ServerConfigPacket;
import ru.dimaskama.webcam.server.WebcamServer;

public class WebcamconfigCommand {
    public static final String COMMAND_NAME = "webcamconfig";
    private static final Map<String, ConfigField<?>> FIELDS = new HashMap();

    private static void putField(ConfigField<?> field) {
        FIELDS.put(field.name, field);
    }

    private static void putIntField(String name, int min, int max, Function<ServerConfig, Integer> getter, BiFunction<ServerConfig, Integer, ServerConfig> withFunction) {
        WebcamconfigCommand.putField(new ConfigField<Integer>(name, getter, withFunction, string -> {
            int intValue;
            try {
                intValue = Integer.parseInt(string);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid integer: " + string);
            }
            if (intValue < min || intValue > max) {
                throw new IllegalArgumentException("Value is not in range [" + min + ";" + max + "]");
            }
            return intValue;
        }));
    }

    private static void putFloatField(String name, float min, float max, Function<ServerConfig, Float> getter, BiFunction<ServerConfig, Float, ServerConfig> withFunction) {
        WebcamconfigCommand.putField(new ConfigField<Float>(name, getter, withFunction, string -> {
            float floatValue;
            try {
                floatValue = Float.parseFloat(string);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid float: " + string);
            }
            if (floatValue < min || floatValue > max) {
                throw new IllegalArgumentException("Value is not in range [" + min + ";" + max + "]");
            }
            return Float.valueOf(floatValue);
        }));
    }

    private static void putDoubleField(String name, double min, double max, Function<ServerConfig, Double> getter, BiFunction<ServerConfig, Double, ServerConfig> withFunction) {
        WebcamconfigCommand.putField(new ConfigField<Double>(name, getter, withFunction, string -> {
            double doubleValue;
            try {
                doubleValue = Float.parseFloat(string);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid float: " + string);
            }
            if (doubleValue < min || doubleValue > max) {
                throw new IllegalArgumentException("Value is not in range [" + min + ";" + max + "]");
            }
            return doubleValue;
        }));
    }

    private static void putStringField(String name, Function<ServerConfig, String> getter, BiFunction<ServerConfig, String, ServerConfig> withFunction) {
        WebcamconfigCommand.putField(new ConfigField<String>(name, getter, withFunction, Function.identity()));
    }

    private static void putBooleanField(String name, Function<ServerConfig, Boolean> getter, BiFunction<ServerConfig, Boolean, ServerConfig> withFunction) {
        WebcamconfigCommand.putField(new ConfigField<Boolean>(name, getter, withFunction, Boolean::parseBoolean));
    }

    public static Stream<String> suggestFields(String start) {
        String lowerCase = start.toLowerCase(Locale.ROOT);
        return FIELDS.keySet().stream().filter(s -> s.startsWith(lowerCase));
    }

    public static String getField(String field) throws IllegalArgumentException {
        ServerConfig config = Webcam.getServerConfig().getData();
        ConfigField<?> configField = FIELDS.get(field);
        if (configField != null) {
            return configField.name + ": " + String.valueOf(configField.getter.apply(config));
        }
        WebcamconfigCommand.unknownField(field);
        return "";
    }

    public static String setField(String field, String newValue) throws IllegalArgumentException {
        ServerConfig config = Webcam.getServerConfig().getData();
        ConfigField<?> configField = FIELDS.get(field);
        if (configField != null) {
            ServerConfig newConfig = WebcamconfigCommand.setNewValue(config, configField, newValue);
            WebcamconfigCommand.updateConfig(config, newConfig);
            return configField.name + " set to " + String.valueOf(configField.getter.apply(newConfig));
        }
        WebcamconfigCommand.unknownField(field);
        return "";
    }

    private static <T> ServerConfig setNewValue(ServerConfig config, ConfigField<T> configField, String newValue) {
        return configField.withFunction.apply(config, (ServerConfig)configField.parser.apply(newValue));
    }

    private static void updateConfig(ServerConfig oldConfig, ServerConfig config) {
        if (!oldConfig.equals(config)) {
            WebcamServer server;
            Webcam.getServerConfig().setData(config);
            Webcam.getServerConfig().save();
            if (!oldConfig.synced().equals(config.synced()) && (server = WebcamServer.getInstance()) != null) {
                server.broadcast(new ServerConfigPacket(config.synced()));
            }
        }
    }

    private static void unknownField(String field) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unknown field: " + field);
    }

    static {
        WebcamconfigCommand.putIntField("port", 0, 65535, ServerConfig::port, ServerConfig::withPort);
        WebcamconfigCommand.putStringField("bind_address", ServerConfig::bindAddress, ServerConfig::withBindAddress);
        WebcamconfigCommand.putStringField("host", ServerConfig::host, ServerConfig::withHost);
        WebcamconfigCommand.putIntField("keep_alive_period", 500, 100000, ServerConfig::keepAlivePeriod, ServerConfig::withKeepAlivePeriod);
        WebcamconfigCommand.putIntField("permission_check_period", 1, 100000, ServerConfig::permissionCheckPeriod, ServerConfig::withPermissionCheckPeriod);
        WebcamconfigCommand.putDoubleField("max_display_distance", 5.0, 100000.0, ServerConfig::maxDisplayDistance, ServerConfig::withMaxDisplayDistance);
        WebcamconfigCommand.putBooleanField("display_on_face", ServerConfig::displayOnFace, ServerConfig::withDisplayOnFace);
        WebcamconfigCommand.putField(new ConfigField<VideoDisplayShape>("display_shape", ServerConfig::displayShape, ServerConfig::withDisplayShape, VideoDisplayShape::byKey));
        WebcamconfigCommand.putFloatField("display_offset_y", -10.0f, 100.0f, ServerConfig::displayOffsetY, ServerConfig::withDisplayOffsetY);
        WebcamconfigCommand.putFloatField("display_size", 0.1f, 200.0f, ServerConfig::displaySize, ServerConfig::withDisplaySize);
        WebcamconfigCommand.putBooleanField("hide_nicknames", ServerConfig::hideNicknames, ServerConfig::withHideNicknames);
        WebcamconfigCommand.putBooleanField("display_self_webcam", ServerConfig::displaySelfWebcam, ServerConfig::withDisplaySelfWebcam);
        WebcamconfigCommand.putIntField("image_dimension", 16, 1440, c -> c.synced().imageDimension(), (c, i) -> c.withSynced(c.synced().withImageDimension((int)i)));
        WebcamconfigCommand.putIntField("mtu", 128, 2048, c -> c.synced().mtu(), (c, i) -> c.withSynced(c.synced().withMtu((int)i)));
        WebcamconfigCommand.putIntField("bitrate", 10, 10000, c -> c.synced().bitrate(), (c, i) -> c.withSynced(c.synced().withBitrate((int)i)));
    }

    private record ConfigField<T>(String name, Function<ServerConfig, T> getter, BiFunction<ServerConfig, T, ServerConfig> withFunction, Function<String, T> parser) {
    }
}

