/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.webcam.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import ru.dimaskama.webcam.client.KnownSourceClient;

public class KnownSourceManager {
    public static final KnownSourceManager INSTANCE = new KnownSourceManager();
    private final Map<UUID, KnownSourceClient> uuidToSource = new ConcurrentHashMap<UUID, KnownSourceClient>();

    public void add(KnownSourceClient source) {
        KnownSourceClient prev = this.uuidToSource.put(source.getUuid(), source);
        if (prev != null) {
            prev.close();
        }
    }

    @Nullable
    public KnownSourceClient get(UUID sourceUuid) {
        return this.uuidToSource.get(sourceUuid);
    }

    public void forEach(Consumer<KnownSourceClient> consumer) {
        this.uuidToSource.values().forEach(consumer);
    }

    public void clear() {
        this.uuidToSource.values().removeIf(source -> {
            source.close();
            return true;
        });
    }
}

