/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5224;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.chat.ClientTextConverter;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.ScissorState;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.pipeline.RenderPipeline;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.extension.TextKt;
import su.plo.voice.universal.TextBuilder;

public final class RenderUtil {
    private static final class_327.class_6415 TEXT_LAYER_TYPE = class_327.class_6415.field_33993;
    private static final ClientTextConverter TEXT_CONVERTER = new ClientTextConverter();
    @Nullable
    private static ScissorState SCISSOR_STATE;

    public static void enableScissor(int x, int y, int width, int height) {
        SCISSOR_STATE = new ScissorState(x, y, width, height);
    }

    public static void disableScissor() {
        SCISSOR_STATE = null;
    }

    public static void clearShader() {
    }

    @NotNull
    public static class_287 beginBuffer(@NotNull RenderPipeline pipeline) {
        class_289 tesselator = class_289.method_1348();
        return tesselator.method_60827(pipeline.getVertexFormatMode().toMc(), pipeline.getVertexFormat());
    }

    public static void drawBuffer(@NotNull class_287 buffer, @NotNull RenderPipeline renderPipeline) {
        try (class_9801 meshData = buffer.method_60794();){
            renderPipeline.getMcRenderType().method_60895(meshData);
        }
        RenderUtil.clearShader();
    }

    public static void bindTexture(int index, @NotNull class_2960 location) {
        RenderSystem.setShaderTexture((int)index, (GpuTextureView)class_310.method_1551().method_1531().method_4619(location).method_71659());
    }

    public static void fill(class_4587 stack, int x0, int y0, int x1, int y1, int color) {
        RenderUtil.fill(stack, RenderPipelines.GUI_COLOR, x0, y0, x1, y1, color);
    }

    public static void fill(class_4587 stack, @NotNull RenderPipeline renderPipeline, int x0, int y0, int x1, int y1, int color) {
        int n;
        if (x0 < x1) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y0 < y1) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float o = (float)(color & 0xFF) / 255.0f;
        class_287 buffer = RenderUtil.beginBuffer(renderPipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, 0.0f).color(g, h, o, f).end();
        RenderUtil.drawBuffer(buffer, renderPipeline);
    }

    public static void fillLight(class_4587 stack, @NotNull RenderPipeline renderPipeline, int x0, int y0, int x1, int y1, int color, int light) {
        int n;
        if (x0 < x1) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y0 < y1) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float o = (float)(color & 0xFF) / 255.0f;
        class_287 buffer = RenderUtil.beginBuffer(renderPipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, 0.0f).color(g, h, o, f).light(light).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, 0.0f).color(g, h, o, f).light(light).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, 0.0f).color(g, h, o, f).light(light).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, 0.0f).color(g, h, o, f).light(light).end();
        RenderUtil.drawBuffer(buffer, renderPipeline);
    }

    public static void fillGradient(class_4587 stack, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z) {
        int f = colorStart >> 24 & 0xFF;
        int g = colorStart >> 16 & 0xFF;
        int h = colorStart >> 8 & 0xFF;
        int i = colorStart & 0xFF;
        int j = colorEnd >> 24 & 0xFF;
        int k = colorEnd >> 16 & 0xFF;
        int l = colorEnd >> 8 & 0xFF;
        int m = colorEnd & 0xFF;
        RenderUtil.fillGradient(stack, startX, startY, endX, endY, g, h, i, f, k, l, m, j, z);
    }

    public static void fillGradient(class_4587 stack, int startX, int startY, int endX, int endY, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha, int z) {
        RenderUtil.fillGradientWithPipeline(stack, RenderPipelines.GUI_COLOR, startX, startY, endX, endY, startRed, startBlue, startGreen, startAlpha, endRed, endBlue, endGreen, endAlpha, z);
    }

    public static void fillGradientWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline renderPipeline, int startX, int startY, int endX, int endY, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha, int z) {
        class_287 buffer = RenderUtil.beginBuffer(renderPipeline);
        RenderUtil.fillGradient(stack, buffer, startX, startY, endX, endY, z, startRed, startBlue, startGreen, startAlpha, endRed, endBlue, endGreen, endAlpha);
        RenderUtil.drawBuffer(buffer, renderPipeline);
    }

    private static void fillGradient(class_4587 stack, class_287 buffer, int startX, int startY, int endX, int endY, int z, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha) {
        VertexBuilder.create(buffer).position(stack, endX, startY, z).color(startRed, startGreen, startBlue, startAlpha).end();
        VertexBuilder.create(buffer).position(stack, startX, startY, z).color(startRed, startGreen, startBlue, startAlpha).end();
        VertexBuilder.create(buffer).position(stack, startX, endY, z).color(endRed, endGreen, endBlue, endAlpha).end();
        VertexBuilder.create(buffer).position(stack, endX, endY, z).color(endRed, endGreen, endBlue, endAlpha).end();
    }

    public static void blitSprite(@NotNull class_4587 stack, @NotNull GuiWidgetTexture sprite, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, u + sprite.getU(), v + sprite.getV(), width, height, sprite.getTextureWidth(), sprite.getTextureHeight());
    }

    public static void blit(class_4587 stack, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, 0, (float)u, (float)v, width, height, 256, 256);
    }

    public static void blit(class_4587 stack, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x, y, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    public static void blit(class_4587 stack, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x, y, width, height, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(class_4587 stack, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blit(class_4587 stack, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x0, x1, y0, y1, z, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blitWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        RenderUtil.blitWithPipeline(stack, pipeline, x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    public static void blit(class_4587 stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderUtil.blitWithPipeline(stack, RenderPipelines.GUI_TEXTURE, x0, x1, y0, y1, z, u0, u1, v0, v1);
    }

    public static void blitWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        class_287 buffer = RenderUtil.beginBuffer(pipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).end();
        RenderUtil.drawBuffer(buffer, pipeline);
    }

    public static void blitColorSprite(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, @NotNull GuiWidgetTexture sprite, int x, int y, int u, int v, int width, int height, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x, y, u + sprite.getU(), v + sprite.getV(), width, height, sprite.getTextureWidth(), sprite.getTextureHeight(), red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x, y, u, v, width, height, width, height, textureWidth, textureHeight, red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x, int y, float u, float v, int width, int height, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight, red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, pipeline, x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight, red, green, blue, alpha);
    }

    public static void blitColorWithPipeline(@NotNull class_4587 stack, @NotNull RenderPipeline pipeline, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        class_287 buffer = RenderUtil.beginBuffer(pipeline);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).color(red, green, blue, alpha).end();
        RenderUtil.drawBuffer(buffer, pipeline);
    }

    public static void blitColor(class_4587 stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        RenderUtil.blitColorWithPipeline(stack, RenderPipelines.GUI_TEXTURE_COLOR, x0, x1, y0, y1, z, u0, u1, v0, v1, red, green, blue, alpha);
    }

    public static void drawStringInBatch(class_4587 stack, String text, int x, int y, int color, boolean shadow) {
        class_4597.class_4598 irendertypebuffer$impl = class_310.method_1551().method_22940().method_23000();
        class_310.method_1551().field_1772.method_27521(text, (float)x, (float)y, color, shadow, stack.method_23760().method_23761(), (class_4597)irendertypebuffer$impl, TEXT_LAYER_TYPE, 0, 0xF000F0);
        irendertypebuffer$impl.method_22993();
    }

    public static int drawCenteredString(class_4587 stack, String string, int x, int y, int color) {
        return RenderUtil.drawCenteredString(stack, string, x, y, color, true);
    }

    public static int drawCenteredString(class_4587 stack, String string, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        int centeredX = x - RenderUtil.getStringWidth(string) / 2;
        RenderUtil.drawStringInBatch(stack, string, centeredX, y, color, dropShadow);
        return RenderUtil.getStringX(string, centeredX, dropShadow);
    }

    public static int drawCenteredString(class_4587 stack, McTextComponent text, int x, int y, int color) {
        return RenderUtil.drawCenteredString(stack, RenderUtil.getFormattedString(text), x, y, color);
    }

    public static void drawCenteredOrderedString(class_4587 stack, McTextComponent text, int width, int x, int y, int color) {
        RenderUtil.drawCenteredOrderedString(stack, text, width, x, y, color, true);
    }

    public static void drawCenteredOrderedString(class_4587 stack, McTextComponent text, int width, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String orderedText = RenderUtil.getOrderedString(text, width);
        RenderUtil.drawStringInBatch(stack, orderedText, x - RenderUtil.getStringWidth(orderedText) / 2, y, color, dropShadow);
    }

    public static void drawOrderedString(class_4587 stack, McTextComponent text, int width, int x, int y, int color) {
        RenderUtil.drawOrderedString(stack, text, width, x, y, color, true);
    }

    public static void drawOrderedString(class_4587 stack, McTextComponent text, int width, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        RenderUtil.drawStringInBatch(stack, RenderUtil.getOrderedString(text, width), x, y, color, dropShadow);
    }

    public static int drawString(class_4587 stack, String string, int x, int y, int color) {
        return RenderUtil.drawString(stack, string, x, y, color, false);
    }

    public static int drawString(class_4587 stack, String string, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        RenderUtil.drawStringInBatch(stack, string, x, y, color, dropShadow);
        return RenderUtil.getStringX(string, x, dropShadow);
    }

    public static int drawString(class_4587 stack, McTextComponent text, int x, int y, int color) {
        return RenderUtil.drawString(stack, text, x, y, color, true);
    }

    public static int drawString(class_4587 stack, McTextComponent text, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String formattedText = RenderUtil.getFormattedString(text);
        RenderUtil.drawStringInBatch(stack, formattedText, x, y, color, dropShadow);
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringLight(class_4587 stack, McTextComponent text, int x, int y, int color, int light, boolean seeThrough, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String formattedText = RenderUtil.getFormattedString(text);
        class_327.class_6415 displayMode = seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        class_4597.class_4598 irendertypebuffer$impl = class_310.method_1551().method_22940().method_23000();
        class_310.method_1551().field_1772.method_27521(formattedText, (float)x, (float)y, color, dropShadow, stack.method_23760().method_23761(), (class_4597)irendertypebuffer$impl, displayMode, 0, light);
        irendertypebuffer$impl.method_22993();
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringMultiLine(class_4587 stack, McTextComponent text, int x, int y, int color, int width) {
        return RenderUtil.drawStringMultiLine(stack, text, x, y, color, width, true);
    }

    public static int drawStringMultiLine(class_4587 stack, McTextComponent text, int x, int y, int color, int width, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = RenderUtil.getFontHeight();
        for (String orderedText : lines) {
            RenderUtil.drawStringInBatch(stack, orderedText, x, y - lineHeight - 1, color, dropShadow);
            y += lineHeight;
        }
        return lines.size();
    }

    public static int drawStringMultiLineCentered(class_4587 stack, McTextComponent text, int width, int y, int yGap, int color) {
        return RenderUtil.drawStringMultiLineCentered(stack, text, width, y, yGap, color, true);
    }

    public static int drawStringMultiLineCentered(class_4587 stack, McTextComponent text, int width, int y, int yGap, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = RenderUtil.getFontHeight();
        for (String orderedText : lines) {
            RenderUtil.drawStringInBatch(stack, orderedText, width / 2 - RenderUtil.getStringWidth(orderedText) / 2, y + lineHeight, color, dropShadow);
            y += lineHeight + yGap;
        }
        return lines.size();
    }

    public static int getStringX(String string, int x, boolean dropShadow) {
        return x + RenderUtil.getStringWidth(string) + (dropShadow ? 1 : 0);
    }

    public static int adjustColor(int color) {
        return (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
    }

    public static String stringToWidth(String string, int width, boolean tail) {
        return RenderUtil.stringToWidth(string, width, tail, "...");
    }

    public static String stringToWidth(String string, int width, boolean tail, String trimmedTextSuffix) {
        List<String> lines = TextKt.splitStringToWidthTruncated(string, width, 1, false, true, trimmedTextSuffix);
        return lines.get(tail ? lines.size() - 1 : 0);
    }

    public static String stringToWidth(String string, int width) {
        return RenderUtil.stringToWidth(string, width, false);
    }

    public static int getTextWidth(McTextComponent text) {
        return RenderUtil.getStringWidth(RenderUtil.getFormattedString(text));
    }

    public static String getOrderedString(McTextComponent text, int width) {
        return TextKt.getTruncatedString(RenderUtil.getFormattedString(text), width, "...");
    }

    public static String getFormattedString(McTextComponent text) {
        class_2561 component = RenderUtil.getTextConverter().convert(text);
        TextBuilder textBuilder = new TextBuilder(true);
        component.method_30937().accept((class_5224)textBuilder);
        return textBuilder.getString();
    }

    public static void lineWidth(float width) {
        RenderSystem.lineWidth((float)width);
    }

    public static int getStringWidth(String string) {
        return class_310.method_1551().field_1772.method_1727(string);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return 9;
    }

    public static ClientTextConverter getTextConverter() {
        return TEXT_CONVERTER;
    }

    private RenderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

