/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.fixes;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.fixes.OS;
import dev.isxander.debugify.mixinplugin.DebugifyDebugFlags;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BugFixData(String bugId, FixCategory category, BugFix.Env env, boolean enabledByDefault, List<String> conflicts, OS requiredOs, @Nullable String description) implements Comparable<BugFixData>
{
    private static final Map<String, Set<String>> externalModConflicts = new HashMap<String, Set<String>>();

    public static void registerApiConflict(String modId, String bugId) {
        externalModConflicts.computeIfAbsent(bugId, b -> new HashSet()).add(modId);
    }

    public Set<String> getActiveConflicts() {
        Set<String> conflicts = this.conflicts().stream().filter(id -> FabricLoader.getInstance().isModLoaded(id)).collect(Collectors.toSet());
        Set<String> apiConflicts = externalModConflicts.get(this.bugId());
        if (apiConflicts != null) {
            conflicts.addAll(apiConflicts);
        }
        return conflicts;
    }

    public boolean satisfiesOSRequirement() {
        return this.requiredOs() == OS.UNKNOWN || this.requiredOs() == OS.getOperatingSystem() || this.requiredOs() == OS.LINUX && DebugifyDebugFlags.FORCE_LINUX_FIXES || this.requiredOs() == OS.WINDOWS && DebugifyDebugFlags.FORCE_WINDOWS_FIXES || this.requiredOs() == OS.MAC && DebugifyDebugFlags.FORCE_MACOS_FIXES;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BugFixData) {
            BugFixData bugFixData = (BugFixData)obj;
            return bugFixData.bugId.equals(this.bugId);
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull BugFixData o) {
        if (o.bugId.length() == this.bugId.length()) {
            return this.bugId.compareTo(o.bugId);
        }
        return Integer.compare(this.bugId.length(), o.bugId.length());
    }
}

