/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.wildfire.api.IGenderArmor;
import com.wildfire.api.WildfireAPI;
import com.wildfire.main.config.FloatConfigKey;
import com.wildfire.resources.GenderArmorResourceManager;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_9334;
import net.minecraft.class_9851;

public final class WildfireHelper {
    public static final PrimitiveCodec<class_9851> TRISTATE = new PrimitiveCodec<class_9851>(){

        public <T> DataResult<class_9851> read(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)ops.getBooleanValue(input).map(v -> v != false ? class_9851.field_52394 : class_9851.field_52395).result().orElse(class_9851.field_52396));
        }

        public <T> T write(DynamicOps<T> ops, class_9851 value) {
            if (value == class_9851.field_52396) {
                return (T)ops.empty();
            }
            return (T)ops.createBoolean(value == class_9851.field_52394);
        }

        public String toString() {
            return "TriState";
        }
    };

    private WildfireHelper() {
        throw new UnsupportedOperationException();
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static float randFloat(float min, float max) {
        return (float)ThreadLocalRandom.current().nextDouble(min, (double)max + 1.0);
    }

    @Environment(value=EnvType.CLIENT)
    public static IGenderArmor getArmorConfig(class_1799 stack) {
        if (stack.method_7960()) {
            return IGenderArmor.EMPTY;
        }
        return GenderArmorResourceManager.get(stack).orElseGet(() -> {
            IGenderArmor fallback = stack.method_57826(class_9334.field_54196) ? IGenderArmor.DEFAULT : IGenderArmor.EMPTY;
            return WildfireAPI.getGenderArmors().getOrDefault(stack.method_7909(), fallback);
        });
    }

    public static Codec<Float> boundedFloat(float minInclusive, float maxInclusive) {
        return Codec.FLOAT.xmap(val -> Float.valueOf(class_3532.method_15363((float)val.floatValue(), (float)minInclusive, (float)maxInclusive)), Function.identity());
    }

    public static Codec<Float> boundedFloat(FloatConfigKey configKey) {
        return WildfireHelper.boundedFloat(configKey.getMinInclusive(), configKey.getMaxInclusive());
    }

    public static String getModVersion(String modId) {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow();
        return mod.getMetadata().getVersion().getFriendlyString();
    }

    public static boolean onClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }
}

