/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.gson.JsonObject;
import com.wildfire.main.WildfireEventHandler;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireSounds;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.cloud.ContributorNametag;
import com.wildfire.main.config.GlobalConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.WildfireSync;
import com.wildfire.resources.GenderArmorResourceManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WildfireGenderClient
implements ClientModInitializer {
    private static final Executor LOAD_EXECUTOR = class_156.method_27958().method_64116("wildfire_gender$loadPlayerData");
    public static final CompletableFuture<Map<UUID, ContributorNametag>> CONTRIBUTOR_NAMETAGS = CloudSync.getContributors();

    public void onInitializeClient() {
        WildfireSounds.register();
        WildfireSync.registerClient();
        WildfireEventHandler.registerClientEvents();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)GenderArmorResourceManager.INSTANCE);
    }

    public static CompletableFuture<@Nullable PlayerConfig> loadGenderInfo(UUID uuid, boolean markForSync, boolean bypassQueue) {
        PlayerConfig cache = WildfireGender.getPlayerById(uuid);
        if (cache == null) {
            return CompletableFuture.completedFuture(null);
        }
        return WildfireGenderClient.loadGenderInfo(cache, markForSync, bypassQueue);
    }

    public static CompletableFuture<@NotNull PlayerConfig> loadGenderInfo(PlayerConfig player, boolean markForSync, boolean bypassQueue) {
        return CompletableFuture.supplyAsync(() -> {
            UUID uuid = player.uuid;
            if (player.hasLocalConfig()) {
                player.loadFromDisk(markForSync);
            } else if (player.syncStatus == PlayerConfig.SyncStatus.UNKNOWN) {
                JsonObject data;
                try {
                    CompletableFuture<JsonObject> future = bypassQueue ? CloudSync.getProfile(uuid) : CloudSync.queueFetch(uuid);
                    data = future.join();
                }
                catch (Exception e) {
                    WildfireGender.LOGGER.error("Failed to fetch profile from sync server", (Throwable)e);
                    throw e;
                }
                if (data != null && player.syncStatus == PlayerConfig.SyncStatus.UNKNOWN) {
                    player.updateFromJson(data);
                    if (markForSync) {
                        player.needsSync = true;
                    }
                }
            }
            return player;
        }, LOAD_EXECUTOR);
    }

    @Nullable
    public static class_2561 getNametag(UUID uuid) {
        ContributorNametag custom;
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (GlobalConfig.INSTANCE.get(GlobalConfig.HIDE_OWN_CONTRIBUTOR_TAG).booleanValue() && clientPlayer != null && uuid.equals(clientPlayer.method_5667())) {
            return null;
        }
        try {
            custom = (ContributorNametag)CONTRIBUTOR_NAMETAGS.getNow(Map.of()).get(uuid);
        }
        catch (Exception e) {
            custom = null;
        }
        if (custom != null) {
            return custom.asText();
        }
        if (WildfireGender.CREATOR_UUID.equals(uuid)) {
            return class_2561.method_43471((String)"wildfire_gender.nametag.creator").method_27692(class_124.field_1076);
        }
        if (WildfireGender.CONTRIBUTOR_UUIDS.contains(uuid)) {
            return class_2561.method_43471((String)"wildfire_gender.nametag.contributor").method_27692(class_124.field_1065);
        }
        return null;
    }
}

