/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.wildfire.gui.GuiUtils;
import com.wildfire.main.config.FloatConfigKey;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class WildfireSlider
extends class_339 {
    private double value;
    private final double minValue;
    private final double maxValue;
    private final FloatConsumer valueUpdate;
    private final Float2ObjectFunction<class_2561> messageUpdate;
    private final FloatConsumer onSave;
    private float lastValue;
    private boolean changed;
    private double arrowKeyStep = 0.05;

    public WildfireSlider(int xPos, int yPos, int width, int height, FloatConfigKey config, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        this(xPos, yPos, width, height, config.getMinInclusive(), config.getMaxInclusive(), currentVal, valueUpdate, messageUpdate, onSave);
    }

    public WildfireSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        super(xPos, yPos, width, height, (class_2561)class_2561.method_43473());
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.valueUpdate = valueUpdate;
        this.messageUpdate = messageUpdate;
        this.onSave = onSave;
        this.setValueInternal(currentVal);
    }

    public void setArrowKeyStep(double arrowKeyStep) {
        this.arrowKeyStep = arrowKeyStep;
    }

    protected void updateMessage() {
        this.method_25355((class_2561)this.messageUpdate.get(this.lastValue));
    }

    protected void applyValue() {
        float newValue = this.getFloatValue();
        if (this.lastValue != newValue) {
            this.valueUpdate.accept(newValue);
            this.lastValue = newValue;
            this.changed = true;
        }
    }

    public void save() {
        if (this.changed) {
            this.onSave.accept(this.lastValue);
            this.changed = false;
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        this.save();
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263 || keyCode == 262) {
            this.value += keyCode == 263 ? -this.arrowKeyStep : this.arrowKeyStep;
            this.value = class_3532.method_15350((double)this.value, (double)0.0, (double)1.0);
            this.applyValue();
            this.updateMessage();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263 || keyCode == 262) {
            this.save();
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.field_22764) {
            int textColor;
            int xP = this.method_46426() + 2;
            ctx.method_25294(xP - 2, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -2145246686);
            int xPos = this.method_46426() + 2 + (int)(this.value * (double)(this.field_22758 - 3));
            ctx.method_25294(this.method_46426() + 1, this.method_46427() + 1, xPos - 1, this.method_46427() + this.field_22759 - 1, this.field_22763 ? -1272831386 : -1273949901);
            if (this.field_22763) {
                int xPos2 = this.method_46426() + 3 + (int)(this.value * (double)(this.field_22758 - 4));
                ctx.method_25294(xPos2 - 2, this.method_46427() + 1, xPos2, this.method_46427() + this.field_22759 - 1, 0x78FFFFFF);
            }
            class_327 font = class_310.method_1551().field_1772;
            int i = this.method_46426() + 2;
            int j = this.method_46426() + this.method_25368() - 2;
            int n = textColor = this.method_25367() && this.field_22763 || this.changed ? 0xFFFF55 : 0xFFFFFF;
            if (!this.field_22763) {
                textColor = 0x666666;
            }
            GuiUtils.drawScrollableTextWithoutShadow(GuiUtils.Justify.CENTER, ctx, font, this.method_25369(), i, this.method_46427(), j, this.method_46427() + this.method_25364(), textColor);
        }
    }

    public float getFloatValue() {
        return (float)this.getValue();
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.setValueInternal(value);
        this.applyValue();
    }

    private void setValueInternal(double value) {
        this.value = class_3532.method_15350((double)((value - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
        this.lastValue = (float)value;
        this.updateMessage();
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()}));
        if (this.field_22763) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }

    private void setValueFromMouse(double mouseX) {
        this.value = (mouseX - (double)(this.method_46426() + 4)) / (double)(this.method_25368() - 8);
        this.value = class_3532.method_15350((double)this.value, (double)0.0, (double)1.0);
        this.applyValue();
        this.updateMessage();
    }
}

