/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.wildfire.main.Gender;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.cloud.ContributorNametag;
import com.wildfire.main.entitydata.PlayerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_746;

public final class SyncedPlayerList {
    private static int ticks = 0;
    private static volatile List<SyncedPlayer> syncedPlayers = Collections.emptyList();

    private SyncedPlayerList() {
        throw new UnsupportedOperationException();
    }

    public static void drawSyncedPlayers(class_332 context, class_327 textRenderer) {
        if (syncedPlayers.isEmpty()) {
            return;
        }
        class_5250 header = class_2561.method_43471((String)"wildfire_gender.wardrobe.players_using_mod").method_27692(class_124.field_1075);
        context.method_51439(textRenderer, (class_2561)header, 5, 5, -1, true);
        int yPos = 18;
        for (SyncedPlayer entry : syncedPlayers) {
            class_5250 text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)entry.name()).method_54663(entry.color())).method_27693(" - ").method_10852(entry.gender().getDisplayName());
            context.method_51439(textRenderer, (class_2561)text, 10, yPos, -1, false);
            yPos += 10;
        }
    }

    private static void onTick(class_310 client) {
        if (ticks++ % 5 != 0) {
            return;
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            syncedPlayers = Collections.emptyList();
            return;
        }
        ArrayList<SyncedPlayer> list = new ArrayList<SyncedPlayer>();
        for (class_640 entry : clientPlayer.field_3944.method_45732()) {
            PlayerConfig config;
            if (Objects.equals(entry.method_2966().getId(), clientPlayer.method_5667()) || (config = WildfireGender.getPlayerById(entry.method_2966().getId())) == null || config.syncStatus == PlayerConfig.SyncStatus.UNKNOWN) continue;
            Integer color = ContributorNametag.getContributorColor(entry.method_2966().getId());
            list.add(new SyncedPlayer(entry.method_2966().getName(), color == null ? 0xFFFFFF : color, config.getGender()));
            if (list.size() < 40) continue;
            break;
        }
        syncedPlayers = list;
    }

    static {
        ClientTickEvents.END_CLIENT_TICK.register(SyncedPlayerList::onTick);
    }

    private record SyncedPlayer(String name, int color, Gender gender) {
    }
}

