/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.utils;

import com.leclowndu93150.particular.mixin.AccessorSpriteContents;
import com.leclowndu93150.particular.mixin.NativeImageAccessor;
import com.leclowndu93150.particular.utils.TextureCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafColorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LeafColorUtil");
    private static final class_5819 renderRandom = class_5819.method_43047();

    public static double[] averageColor(class_1011 image) {
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            LOGGER.error("RGBA image required, was {}", (Object)image.method_4318());
            return new double[]{1.0, 1.0, 1.0};
        }
        long pixels = ((NativeImageAccessor)image).getPixels();
        if (pixels == 0L) {
            LOGGER.error("Image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.method_4307();
        int height = image.method_4323();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pixels + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        if (n == 0) {
            return new double[]{1.0, 1.0, 1.0};
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }

    public static double[] getBlockTextureColor(class_2680 state, class_1937 world, class_2338 pos) {
        boolean shouldColor;
        class_1058 sprite;
        class_310 client = class_310.method_1551();
        class_1087 model = client.method_1541().method_3349(state);
        renderRandom.method_43052(state.method_26190(pos));
        List parts = model.method_68512(renderRandom);
        ObjectArrayList quads = new ObjectArrayList();
        for (class_10889 part : parts) {
            quads.addAll(part.method_68509(class_2350.field_11033));
        }
        if (!quads.isEmpty()) {
            class_777 quad = (class_777)quads.get(0);
            sprite = quad.comp_3724();
            shouldColor = quad.method_3360();
        } else {
            sprite = model.method_68511();
            shouldColor = true;
        }
        class_7764 contents = sprite.method_45851();
        class_2960 spriteId = contents.method_45816();
        class_1011 texture = ((AccessorSpriteContents)contents).getByMipLevel()[0];
        int blockColor = shouldColor ? client.method_1505().method_1697(state, (class_1920)world, pos, 0) : -1;
        return LeafColorUtil.calculateLeafColor(spriteId, texture, blockColor);
    }

    private static double[] calculateLeafColor(class_2960 spriteId, class_1011 texture, int blockColor) {
        double[] textureColor = TextureCache.INST.computeIfAbsent(spriteId, loc -> {
            double[] doubles = LeafColorUtil.averageColor(texture);
            return new TextureCache.Data(doubles);
        }).getColor();
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }

    public static Color getColorFromValues(double[] values) {
        return new Color((float)Math.max(0.0, Math.min(1.0, values[0])), (float)Math.max(0.0, Math.min(1.0, values[1])), (float)Math.max(0.0, Math.min(1.0, values[2])));
    }
}

