/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.imaginebook.mixin;

import io.github.jumperonjava.imaginebook.ImageSerializer;
import io.github.jumperonjava.imaginebook.Imaginebook;
import io.github.jumperonjava.imaginebook.image.Image;
import io.github.jumperonjava.imaginebook.image.ImageData;
import io.github.jumperonjava.imaginebook.mixin.accessor.ScreenAccessor;
import io.github.jumperonjava.imaginebook.util.DeletedImageData;
import io.github.jumperonjava.imaginebook.util.VersionFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11385;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_473;
import net.minecraft.class_474;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_7529;
import net.minecraft.class_8016;
import net.minecraft.class_9301;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_473.class})
public abstract class NewBookEditScreenMixin
extends class_437 {
    @Shadow
    private int field_2840;
    @Shadow
    @Final
    private List<String> field_17116;
    @Shadow
    private class_474 field_2843;
    @Shadow
    private class_474 field_2839;
    @Shadow
    private class_2561 field_60461;
    @Shadow
    private class_7529 field_60462;
    private class_342 urlField;
    private class_342 xPosField;
    private class_342 widthField;
    private class_342 yPosField;
    private class_342 heightField;
    private class_342 spinField;
    private class_4185 xPosButton;
    private class_4185 yPosButton;
    private class_4185 widthButton;
    private class_4185 heightButton;
    private class_4185 spinButton;
    private class_4185 removeButton;
    private class_4185 addButton;
    private class_2561 error;
    List<List<ImageData>> display_pages = new ArrayList<List<ImageData>>();
    int currentEdited = -1;
    public int draggedByMouse = -1;
    public double bufferX;
    public double bufferY;

    protected NewBookEditScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void construct(class_1657 player, class_1799 stack, class_1268 hand, class_9301 writableBookContent, CallbackInfo ci) {
        for (int i = 0; i < 250; ++i) {
            this.display_pages.add(new ArrayList());
        }
        this.updateDisplayImages();
    }

    void updateDisplayImages() {
        for (int i = 0; i < this.field_17116.size(); ++i) {
            String page = this.field_17116.get(i);
            this.display_pages.set(i, ImageSerializer.parseSafeModeImages(page));
        }
        this.currentEdited = Math.min(this.currentEdited, this.display_pages.get(this.field_2840).size() - 1);
    }

    private String getCurrentPageContent() {
        if (this.field_2840 >= this.field_17116.size()) {
            return "";
        }
        return this.field_17116.get(this.field_2840);
    }

    private void setCurrentPageContent(String content) {
        this.field_17116.set(this.field_2840, content);
        this.field_60462.method_72234(content, true);
    }

    private void setCurrentEdited(int imageId) {
        this.currentEdited = imageId;
        if (this.currentEdited == -1) {
            this.method_25395(null);
        } else {
            this.updateFields();
        }
    }

    @Nullable
    ImageData getCurrentPageImage(int id) {
        if (id == -1) {
            return null;
        }
        if (this.display_pages.get(this.field_2840).isEmpty()) {
            return null;
        }
        return this.display_pages.get(this.field_2840).get(id);
    }

    void addCurrentPageImage(ImageData image) {
        this.setCurrentPageContent(this.getCurrentPageContent() + image.bookString());
        this.updateDisplayImages();
    }

    protected void method_48263(class_8016 path) {
        ((ScreenAccessor)((Object)this)).invokeBlur();
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    void init(CallbackInfo ci) {
        int i;
        int elementHeight = 20;
        int gap = 4;
        int heightOffset = this.field_22790 - 50;
        int columnSize = 100 - gap;
        int smallFieldWidth = columnSize - 24;
        int[] row = new int[10];
        int[] column = new int[10];
        int[] fieldColumn = new int[10];
        for (i = 0; i < 10; ++i) {
            row[i] = i * (elementHeight + gap) + gap;
        }
        for (i = 0; i < 10; ++i) {
            column[i] = i * (columnSize + gap) + gap;
        }
        for (i = 0; i < 10; ++i) {
            fieldColumn[i] = column[i] + 24;
        }
        int urlFieldX = column[0];
        int urlFieldY = row[0];
        int urlFieldWidth = columnSize * 2 + gap;
        int addButtonX = column[0];
        int addButtonY = row[1];
        int addButtonWidth = columnSize;
        int removeButtonX = column[1];
        int removeButtonY = row[1];
        int removeButtonWidth = columnSize;
        int xPosButtonX = column[2];
        int xPosButtonY = row[0];
        int xPosFieldX = fieldColumn[2];
        int xPosFieldY = row[0];
        int yPosButtonX = column[2];
        int yPosButtonY = row[1];
        int yPosFieldX = fieldColumn[2];
        int yPosFieldY = row[1];
        int widthButtonX = column[3];
        int widthButtonY = row[0];
        int widthFieldX = fieldColumn[3];
        int widthFieldY = row[0];
        int heightButtonX = column[3];
        int heightButtonY = row[1];
        int heightFieldX = fieldColumn[3];
        int heightFieldY = row[1];
        int spinButtonX = column[4];
        int spinButtonY = row[1];
        int spinFieldX = fieldColumn[4];
        int spinFieldY = row[1];
        urlFieldY += heightOffset;
        addButtonY += heightOffset;
        removeButtonY += heightOffset;
        xPosButtonY += heightOffset;
        xPosFieldY += heightOffset;
        yPosButtonY += heightOffset;
        yPosFieldY += heightOffset;
        widthButtonY += heightOffset;
        widthFieldY += heightOffset;
        heightButtonY += heightOffset;
        heightFieldY += heightOffset;
        spinButtonY += heightOffset;
        spinFieldY += heightOffset;
        this.urlField = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, urlFieldX, urlFieldY, urlFieldWidth, elementHeight, (class_2561)class_2561.method_43471((String)"imaginebook.gui.urlhere")));
        this.urlField.method_1880(256);
        this.urlField.method_1863(url -> {
            ImageData getCurrentEdited = this.getCurrentEdited();
            if (getCurrentEdited == null) {
                return;
            }
            if (url.equals(getCurrentEdited.getUrl())) {
                return;
            }
            if (url.length() > 255) {
                this.urlField.method_1852(class_1074.method_4662((String)"imaginebook.error.too_long", (Object[])new Object[0]));
                return;
            }
            this.mutateImage(this.currentEdited, imageData -> {
                imageData.heightFraction = 1.0f;
                imageData.widthFraction = 1.0f;
                imageData.setUrl(Imaginebook.fixImgurLink(url));
                return imageData;
            });
        });
        this.addButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"imaginebook.gui.add"), b -> {
            ImageData newImage = new ImageData("", 0, 0, 1.0f, 1.0f);
            this.addCurrentPageImage(newImage);
            this.setCurrentEdited(this.display_pages.get(this.field_2840).size() - 1);
        }).method_46433(addButtonX, addButtonY).method_46437(addButtonWidth, elementHeight).method_46431());
        this.removeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"imaginebook.gui.remove"), b -> this.mutateImage(this.currentEdited, imageData -> {
            this.setCurrentEdited(-1);
            return new DeletedImageData();
        })).method_46433(removeButtonX, removeButtonY).method_46437(removeButtonWidth, elementHeight).method_46431());
        this.xPosButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21c4"), b -> {}).method_46433(xPosButtonX, xPosButtonY).method_46437(20, elementHeight).method_46431());
        this.xPosField = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, xPosFieldX, xPosFieldY, smallFieldWidth, elementHeight, (class_2561)class_2561.method_43473()));
        this.xPosField.method_1863(this.createSetter(x -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.x = x.floatValue();
            return imageData;
        }), this.xPosField));
        this.yPosButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21c5"), b -> {}).method_46433(yPosButtonX, yPosButtonY).method_46437(20, elementHeight).method_46431());
        this.yPosField = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, yPosFieldX, yPosFieldY, smallFieldWidth, elementHeight, (class_2561)class_2561.method_43473()));
        this.yPosField.method_1863(this.createSetter(y -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.y = y.floatValue();
            return imageData;
        }), this.yPosField));
        this.widthButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21d4"), b -> {}).method_46433(widthButtonX, widthButtonY).method_46437(20, elementHeight).method_46431());
        this.widthField = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, widthFieldX, widthFieldY, smallFieldWidth, elementHeight, (class_2561)class_2561.method_43473()));
        this.widthField.method_1863(this.createSetter(w -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.widthFraction = (float)Math.round(w.floatValue()) / 100.0f;
            return imageData;
        }), this.widthField));
        this.heightButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21d5"), b -> {}).method_46433(heightButtonX, heightButtonY).method_46437(20, elementHeight).method_46431());
        this.heightField = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, heightFieldX, heightFieldY, smallFieldWidth, elementHeight, (class_2561)class_2561.method_43473()));
        this.heightField.method_1863(this.createSetter(h -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.heightFraction = (float)Math.round(h.floatValue()) / 100.0f;
            return imageData;
        }), this.heightField));
        this.spinButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u21bb"), b -> {}).method_46433(spinButtonX, spinButtonY).method_46437(20, elementHeight).method_46431());
        this.spinField = (class_342)this.method_37063((class_364)new class_342(this.field_22787.field_1772, spinFieldX, spinFieldY, smallFieldWidth, elementHeight, (class_2561)class_2561.method_43473()));
        this.spinField.method_1863(this.createSetter(h -> this.mutateImage(this.currentEdited, imageData -> {
            imageData.rotation = 0.0f;
            imageData.rotate(h.floatValue());
            return imageData;
        }), this.spinField));
        this.removeButton.field_22764 = false;
        this.urlField.method_1862(false);
        this.xPosField.method_1862(false);
        this.xPosButton.field_22764 = false;
        this.yPosField.method_1862(false);
        this.yPosButton.field_22764 = false;
        this.widthField.method_1862(false);
        this.widthButton.field_22764 = false;
        this.heightField.method_1862(false);
        this.heightButton.field_22764 = false;
        this.spinField.method_1862(false);
        this.spinButton.field_22764 = false;
        this.updateFields();
    }

    private ImageData getCurrentEdited() {
        return this.getCurrentPageImage(this.currentEdited);
    }

    private void updateFields() {
        ArrayList pageErrors = new ArrayList();
        if (pageErrors.size() > 0) {
            Imaginebook.cancelledFinalize = true;
            this.error = class_2561.method_43469((String)"imaginebook.error.too_long_encoded", (Object[])new Object[]{String.join((CharSequence)", ", (CharSequence[])pageErrors.stream().map(s -> String.valueOf(s + 1)).toArray(String[]::new))});
        } else {
            Imaginebook.cancelledFinalize = false;
            this.error = class_2561.method_43473();
        }
        if (this.currentEdited == -1) {
            return;
        }
        ImageData currentPageImage = this.getCurrentEdited();
        if (currentPageImage != null) {
            this.urlField.method_1852(currentPageImage.getUrl());
            String xpos = String.valueOf((int)currentPageImage.x());
            this.xPosField.method_1852(xpos);
            String ypos = String.valueOf((int)currentPageImage.y());
            this.yPosField.method_1852(ypos);
            String width = String.valueOf(currentPageImage.widthFraction() * 100.0f);
            this.widthField.method_1852(width);
            String height = String.valueOf(currentPageImage.heightFraction() * 100.0f);
            this.heightField.method_1852(height);
            this.spinField.method_1852("" + currentPageImage.rotation);
        }
    }

    Consumer<String> createSetter(Consumer<Float> setter, class_342 fieldWidget) {
        return value -> {
            try {
                float number = Float.parseFloat(value);
                if (String.valueOf(Math.round(number)).equals("0")) {
                    setter.accept(Float.valueOf(0.0f));
                } else if (!fieldWidget.method_1882().equals(String.valueOf(Math.round(number)))) {
                    fieldWidget.method_1852(String.valueOf(Math.round(number)));
                } else {
                    setter.accept(Float.valueOf(number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        };
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        class_4185[] buttons;
        List<ImageData> images = this.display_pages.get(this.field_2840);
        boolean inSigningScreen = this.field_22787.field_1755 instanceof class_11385;
        if (inSigningScreen) {
            return false;
        }
        for (class_4185 button : buttons = new class_4185[]{this.field_2843, this.field_2839}) {
            if (!button.method_25405(mouseX, mouseY)) continue;
            button.method_25306();
            return true;
        }
        int i = 0;
        for (ImageData image : images) {
            if (this.isMouseOver(image, mouseX, mouseY)) {
                this.setCurrentEdited(i);
                this.draggedByMouse = i;
                return true;
            }
            ++i;
        }
        if (this.isMouseOver(new ImageData("", 0, 0, 192.0f, 192.0f), mouseX, mouseY)) {
            this.method_25395(null);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            return false;
        }
        if (this.draggedByMouse != -1) {
            this.bufferX += deltaX;
            this.bufferY += deltaY;
            this.mutateImage(this.draggedByMouse, imageData -> {
                imageData.x += (float)((int)this.bufferX);
                imageData.y += (float)((int)this.bufferY);
                return imageData;
            });
            this.bufferX -= (double)((int)this.bufferX);
            this.bufferY -= (double)((int)this.bufferY);
            this.updateFields();
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggedByMouse != -1) {
            this.updateFields();
            this.draggedByMouse = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    void mutateImage(int id, Function<ImageData, ImageData> function) {
        if (id == -1) {
            return;
        }
        this.getCurrentPageImage(id);
        ImageData original = new ImageData(this.getCurrentPageImage(id));
        ImageData modifiedImage = function.apply(original);
        Pattern pattern = Pattern.compile("\\[.*?\\]");
        Matcher matcher = pattern.matcher(this.getCurrentPageContent());
        ArrayList images = new ArrayList();
        int index = 0;
        String newPage = this.getCurrentPageContent();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (index == id) {
                StringBuffer buf = new StringBuffer(newPage).delete(start, end).insert(start, modifiedImage.bookString());
                newPage = buf.toString();
                break;
            }
            ++index;
        }
        this.setCurrentPageContent(newPage);
        this.updateDisplayImages();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        boolean inSigningScreen = this.field_22787.field_1755 instanceof class_11385;
        if (!inSigningScreen) {
            verticalAmount = Math.signum(verticalAmount);
            if (NewBookEditScreenMixin.method_25441()) {
                verticalAmount *= 5.0;
            }
            if (NewBookEditScreenMixin.method_25442()) {
                verticalAmount *= 5.0;
            }
            if (NewBookEditScreenMixin.method_25443()) {
                verticalAmount *= 5.0;
            }
            boolean pressed = false;
            if (this.getCurrentEdited() != null) {
                double finalVerticalAmount = verticalAmount;
                Image.ImageSize currentNativeImage = this.getCurrentEdited().getImage().getSize();
                if (this.xPosButton.method_25405(mouseX, mouseY) || this.xPosField.method_25405(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.x += (float)finalVerticalAmount;
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.yPosButton.method_25405(mouseX, mouseY) || this.yPosField.method_25405(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.y += (float)finalVerticalAmount;
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.widthButton.method_25405(mouseX, mouseY) || this.widthField.method_25405(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.widthFraction += (float)(finalVerticalAmount / (double)currentNativeImage.getWidth());
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.heightButton.method_25405(mouseX, mouseY) || this.heightField.method_25405(mouseX, mouseY)) {
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.heightFraction += (float)(finalVerticalAmount / (double)currentNativeImage.getHeight());
                        return imageData;
                    });
                    pressed = true;
                }
                if (this.spinButton.method_25405(mouseX, mouseY) || this.spinField.method_25405(mouseX, mouseY)) {
                    if (verticalAmount == 25.0) {
                        verticalAmount = 15.0;
                    }
                    if (verticalAmount == 125.0) {
                        verticalAmount = 90.0;
                    }
                    if (verticalAmount == -25.0) {
                        verticalAmount = -15.0;
                    }
                    if (verticalAmount == -125.0) {
                        verticalAmount = -90.0;
                    }
                    this.mutateImage(this.currentEdited, imageData -> {
                        imageData.rotate((float)finalVerticalAmount);
                        return imageData;
                    });
                    pressed = true;
                }
            }
            if (!pressed) {
                int targetImage1 = -1;
                int i = 0;
                for (ImageData image : this.display_pages.get(this.field_2840)) {
                    if (this.isMouseOver(image, mouseX, mouseY) && targetImage1 == -1) {
                        targetImage1 = i;
                        break;
                    }
                    ++i;
                }
                if (this.draggedByMouse != -1) {
                    targetImage1 = this.draggedByMouse;
                }
                double finalVerticalAmount = verticalAmount;
                this.mutateImage(targetImage1, targetImage -> {
                    double localVerticalAmount = finalVerticalAmount;
                    if (targetImage != null) {
                        if (NewBookEditScreenMixin.method_25442() || NewBookEditScreenMixin.method_25443()) {
                            localVerticalAmount /= 5.0;
                        }
                        double pow = Math.pow(1.0 + Math.abs(localVerticalAmount * 0.01), Math.signum(localVerticalAmount));
                        float min = Math.min(targetImage.renderWidth(), targetImage.renderHeight());
                        if (Math.abs((double)min - (double)min * pow) < 1.0) {
                            pow = ((double)min + localVerticalAmount) / (double)min;
                        }
                        if (!NewBookEditScreenMixin.method_25443()) {
                            targetImage.widthFraction = (float)((double)targetImage.widthFraction * pow);
                        }
                        if (!NewBookEditScreenMixin.method_25442()) {
                            targetImage.heightFraction = (float)((double)targetImage.heightFraction * pow);
                        }
                    }
                    return targetImage;
                });
            }
            this.updateFields();
            if (pressed) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.updateFields();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.field_2840 = class_3532.method_15340((int)this.field_2840, (int)-1, (int)(this.display_pages.size() - 1));
        if (this.error != null) {
            context.method_27534(this.field_22787.field_1772, this.error, this.field_22789 / 2, this.field_22790 - 20, class_9848.method_61324((int)255, (int)255, (int)100, (int)100));
        }
        boolean editing = this.currentEdited != -1;
        boolean inSigningScreen = this.field_22787.field_1755 instanceof class_11385;
        if (inSigningScreen) {
            editing = false;
        }
        this.addButton.field_22764 = !inSigningScreen;
        this.removeButton.field_22764 = editing;
        this.urlField.method_1862(editing);
        this.xPosField.method_1862(editing);
        this.xPosButton.field_22764 = editing;
        this.yPosField.method_1862(editing);
        this.yPosButton.field_22764 = editing;
        this.widthField.method_1862(editing);
        this.widthButton.field_22764 = editing;
        this.heightField.method_1862(editing);
        this.heightButton.field_22764 = editing;
        this.spinField.method_1862(editing);
        this.spinButton.field_22764 = editing;
        if (inSigningScreen) {
            return;
        }
        int bookX = this.field_22789 / 2 - 96;
        int bookY = 2;
        ArrayList combined = new ArrayList();
        combined.addAll(this.display_pages.get(this.field_2840));
        for (Object imageData : VersionFunctions.reversed(combined)) {
            ((ImageData)imageData).renderImage(context, bookX, bookY);
        }
        List<ImageData> images = this.display_pages.get(this.field_2840);
        if (images != null) {
            for (ImageData imageData : images) {
                if (!this.isMouseOver(imageData, mouseX, mouseY)) continue;
                context.method_25294((int)((float)bookX + imageData.x()), (int)((float)bookY + imageData.y()), (int)((float)bookX + imageData.x() + imageData.renderWidth()), (int)((float)bookY + imageData.y() + imageData.renderHeight()), 0xFFFFFFF);
                break;
            }
        }
        List.of(this.urlField, this.addButton, this.removeButton, this.widthButton, this.widthField, this.heightButton, this.heightField, this.xPosButton, this.xPosField, this.yPosButton, this.yPosField, this.field_2843, this.field_2839, this.spinButton, this.spinField).forEach(e -> e.method_25394(context, mouseX, mouseY, delta));
        int i = (this.field_22789 - 192) / 2;
        int j = 2;
        int n = this.field_22793.method_27525((class_5348)this.field_60461);
        context.method_51439(this.field_22793, this.field_60461, i - n + 192 - 44, 18, 0x3F000000, false);
        int contentAreaX = (this.field_22789 - 114) / 2 - 4;
        int contentAreaY = 32;
        List wrappedLines = this.field_22793.method_1728(class_5348.method_29430((String)this.getCurrentPageContent()), 114);
        int currentLineY = contentAreaY;
        Objects.requireNonNull(this.field_22793);
        int lineHeight = 9;
        for (class_5481 line : wrappedLines) {
            int lineDrawY = currentLineY;
            context.method_51430(this.field_22793, line, contentAreaX, lineDrawY, 0x3F000000, false);
            currentLineY += lineHeight;
        }
    }

    public boolean isMouseOver(ImageData imageData, double mouseX, double mouseY) {
        return ImageData.isMouseOverImage(imageData, mouseX, mouseY, this.field_22789 / 2);
    }

    @Inject(method={"finalizeBook"}, at={@At(value="HEAD")}, cancellable=true)
    void finalizeBook(CallbackInfo ci) {
        if (Imaginebook.cancelledFinalize) {
            ci.cancel();
            return;
        }
    }
}

