/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.autoreconnectrf.AutoReconnect;
import dev.terminalmc.autoreconnectrf.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path DIR_PATH = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "autoreconnectrf.json";
    private static final String BACKUP_FILE_NAME = "autoreconnectrf.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    public int getDelayForAttempt(int attempt) {
        if (attempt < this.options.delays.size()) {
            return this.options.delays.get(attempt);
        }
        if (this.options.infinite) {
            return this.options.delays.getLast();
        }
        return -1;
    }

    public boolean hasAttempts() {
        return !this.options.delays.isEmpty();
    }

    public List<AutoMessage> getAutoMessagesForId(String id) {
        return this.options.autoMessages.stream().filter(autoMessage -> {
            if (this.options.regexIds) {
                try {
                    return Pattern.compile(autoMessage.id).matcher(id).matches();
                }
                catch (PatternSyntaxException ignored) {
                    return false;
                }
            }
            return autoMessage.id.equals(id);
        }).toList();
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config reloadAndSave() {
        instance = Config.load();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    private void validate() {
        if (this.options.delays == null) {
            this.options.delays = Options.delaysDefault.get();
        } else if (!this.options.delays.isEmpty()) {
            this.options.delays = this.options.delays.stream().filter(i -> i > 0).toList();
        }
        if (this.options.autoMessages == null) {
            this.options.autoMessages = Options.autoMessagesDefault.get();
        } else if (!this.options.autoMessages.isEmpty()) {
            for (AutoMessage autoMessage : this.options.autoMessages) {
                if (autoMessage.id == null) {
                    autoMessage.id = "";
                }
                if (autoMessage.messages == null) {
                    autoMessage.messages = AutoMessage.messagesDefault.get();
                } else if (!autoMessage.messages.isEmpty()) {
                    autoMessage.messages = autoMessage.messages.stream().filter(Objects::nonNull).toList();
                }
                if (!(autoMessage.delay <= 0.0f)) continue;
                autoMessage.delay = 1.0f;
            }
        }
    }

    @NotNull
    public static Config load() {
        Path file = DIR_PATH.resolve(FILE_NAME);
        @Nullable Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            AutoReconnect.LOG.warn("Resetting config", new Object[0]);
        }
        if (config == null) {
            config = new Config();
        }
        config.validate();
        return config;
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                AutoReconnect.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            AutoReconnect.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            AutoReconnect.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(DIR_PATH, new LinkOption[0])) {
                Files.createDirectories(DIR_PATH, new FileAttribute[0]);
            }
            Path file = DIR_PATH.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            AutoReconnect.onConfigSaved(instance);
        }
        catch (IOException e) {
            AutoReconnect.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final Supplier<List<Integer>> delaysDefault = () -> new ArrayList<Integer>(List.of(Integer.valueOf(3), Integer.valueOf(10), Integer.valueOf(30), Integer.valueOf(60)));
        public List<Integer> delays = delaysDefault.get();
        public static final boolean infiniteDefault = false;
        public boolean infinite = false;
        public static final boolean conditionTypeDefault = false;
        public boolean conditionType = false;
        public static final Supplier<List<String>> conditionKeysDefault = () -> new ArrayList<String>(List.of("multiplayer.disconnect.banned"));
        public List<String> conditionKeys = conditionKeysDefault.get();
        public static final Supplier<List<String>> conditionPatternsDefault = () -> new ArrayList(List.of());
        public List<String> conditionPatterns = conditionPatternsDefault.get();
        public static final Supplier<List<AutoMessage>> autoMessagesDefault = () -> new ArrayList(List.of());
        public List<AutoMessage> autoMessages = autoMessagesDefault.get();
        public static final boolean commandSigningDefault = false;
        public boolean commandSigning = false;
        public static final boolean regexIdsDefault = false;
        public boolean regexIds = false;
    }

    public static final class AutoMessage {
        public static final String idDefault = "";
        public String id = "";
        public static final float delayDefault = 1.0f;
        public float delay = 1.0f;
        public static final Supplier<List<String>> messagesDefault = List::of;
        public List<String> messages = messagesDefault.get();

        public Iterator<String> getMessages() {
            return this.messages.iterator();
        }
    }
}

