/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Tooltip;

public class Checkbox
extends GuiElement {
    private String name;
    protected Runnable action;
    private boolean selected;
    private Tooltip tooltip;

    public Checkbox(IGui gui, String name) {
        super(gui);
        this.name = name;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.h, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.h - 2, this.bounds.h - 2, bgColor);
        this.gui.drawText(this.bounds.x + this.bounds.h + 3, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
        if (this.selected) {
            this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, 16, 16, 32, 0, "editor", color);
        }
    }

    @Override
    public boolean mouseClick(int x, int y, int btn) {
        if (this.enabled && this.bounds.isInBounds(x, y)) {
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }
        return false;
    }

    public void setText(String name) {
        this.name = name;
    }

    public String getText() {
        return this.name;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public void updateState(Boolean b) {
        this.setEnabled(b != null);
        if (b != null) {
            this.setSelected(b);
        } else {
            this.setSelected(false);
        }
    }
}

