/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.thread.GlobalExecutors;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3568;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_3227.class})
public abstract class ThreadedLevelLightEngineMixin
extends class_3568
implements StarLightLightingProvider {
    @Final
    @Shadow
    private class_3898 field_17257;
    @Final
    @Shadow
    private static Logger field_14020;
    @Unique
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();
    @Unique
    private final AtomicLong scalablelux$lastLightUpdate = new AtomicLong(0L);

    @Shadow
    public abstract void method_17303();

    public ThreadedLevelLightEngineMixin(class_2823 chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Unique
    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<StarLightInterface.LightQueue.ChunkTasks> runnable) {
        class_3218 world = (class_3218)this.getLightEngine().getWorld();
        class_2791 center = this.getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.method_12009().method_12165(class_2806.field_12805)) {
            return;
        }
        if (center.method_12009() != class_2806.field_12803) {
            runnable.get();
            return;
        }
        if (!world.method_14178().field_17254.field_17216.method_18854()) {
            world.method_14178().field_17254.field_17216.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        StarLightInterface.LightQueue.ChunkTasks updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        if (updateFuture.isTicketAdded) {
            return;
        }
        updateFuture.isTicketAdded = true;
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            class_1923 pos = new class_1923(chunkX, chunkZ);
            world.method_14178().method_66009(StarLightInterface.CHUNK_WORK_TICKET, pos, 0);
        }
        ((CompletableFuture)updateFuture.onComplete.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                class_1923 pos = new class_1923(chunkX, chunkZ);
                world.method_14178().method_66010(StarLightInterface.CHUNK_WORK_TICKET, pos, 0);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.method_14178().field_17254.field_17216)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                field_14020.error("Failed to remove ticket level for post chunk task " + String.valueOf(new class_1923(chunkX, chunkZ)), thr);
            }
        });
    }

    @Overwrite
    public void method_15513(class_2338 pos) {
        class_2338 posCopy = pos.method_10062();
        this.queueTaskForSection(posCopy.method_10263() >> 4, posCopy.method_10264() >> 4, posCopy.method_10260() >> 4, () -> this.getLightEngine().blockChange(posCopy));
    }

    @Overwrite
    public void method_20386(class_1923 pos) {
    }

    @Overwrite
    public void method_15551(class_4076 pos, boolean notReady) {
        this.queueTaskForSection(pos.method_10263(), pos.method_10264(), pos.method_10260(), () -> this.getLightEngine().sectionChange(pos, notReady));
    }

    @Overwrite
    public void method_51471(class_1923 pos) {
    }

    @Overwrite
    public void method_15512(class_1923 pos, boolean lightEnabled) {
    }

    @Overwrite
    public void method_15558(class_1944 lightType, class_4076 pos, @Nullable class_2804 nibbles) {
    }

    @Overwrite
    public void method_20601(class_1923 pos, boolean retainData) {
    }

    @Overwrite
    public CompletableFuture<class_2791> method_51285(class_2791 chunk, boolean lit) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Overwrite
    public CompletableFuture<class_2791> method_17310(class_2791 chunk, boolean lit) {
        class_1923 chunkPos = chunk.method_12004();
        return CompletableFuture.supplyAsync(() -> {
            Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(chunk);
            if (!lit) {
                chunk.method_12020(false);
                this.getLightEngine().lightChunk(chunk, emptySections);
                chunk.method_12020(true);
            } else {
                this.getLightEngine().forceLoadInChunk(chunk, emptySections);
                this.getLightEngine().checkChunkEdges(chunkPos.field_9181, chunkPos.field_9180);
            }
            return chunk;
        }, runnable -> {
            this.getLightEngine().scheduleChunkLight(chunkPos, runnable);
            this.method_17303();
        }).whenComplete((c, throwable) -> {
            if (throwable != null) {
                field_14020.error("Failed to light chunk " + String.valueOf(chunkPos), throwable);
            }
        });
    }

    @WrapOperation(method={"tryScheduleUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/lighting/LevelLightEngine;hasLightWork()Z")})
    private boolean scheduleOnlyWhenDirty(class_3227 instance, Operation<Boolean> original) {
        if (!GlobalExecutors.ENABLED) {
            return (Boolean)original.call(new Object[]{instance});
        }
        boolean queueDirty = ((StarLightLightingProvider)instance).getLightEngine().isQueueDirty();
        if (queueDirty) {
            return (Boolean)original.call(new Object[]{instance});
        }
        long lastUpdate = this.scalablelux$lastLightUpdate.get();
        long currentTime = System.nanoTime();
        if (currentTime - lastUpdate >= 10000000L && this.scalablelux$lastLightUpdate.compareAndSet(lastUpdate, currentTime)) {
            return (Boolean)original.call(new Object[]{instance});
        }
        return false;
    }

    @Overwrite
    public CompletableFuture<?> method_53694(int x, int z) {
        return this.getLightEngine().syncFuture(x, z);
    }
}

