/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.compat;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.BatteryTrackerConfig;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.BatteryIndicatorCondition;
import dynamic_fps.impl.config.option.BatteryIndicatorPlacement;
import dynamic_fps.impl.config.option.GraphicsState;
import dynamic_fps.impl.config.option.IdleCondition;
import dynamic_fps.impl.config.option.IgnoreInitialClick;
import dynamic_fps.impl.util.Components;
import dynamic_fps.impl.util.VariableStepTransformer;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public final class ClothConfig {
    public static class_437 genConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)Components.translatable("config", "title", new Object[0])).setSavingRunnable(DynamicFPSMod::onConfigChanged);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)Components.translatable("config", "category.general", new Object[0]));
        DynamicFPSConfig config = DynamicFPSConfig.INSTANCE;
        DynamicFPSConfig defaultConfig = DynamicFPSConfig.DEFAULTS;
        SubCategoryBuilder misc = entryBuilder.startSubCategory((class_2561)Components.translatable("config", "feature.misc", new Object[0]));
        misc.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "enabled", new Object[0]), config.enabled()).setDefaultValue(defaultConfig.enabled()).setSaveConsumer(config::setEnabled).build());
        misc.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "uncap_menu_frame_rate", new Object[0]), config.uncapMenuFrameRate()).setDefaultValue(defaultConfig.uncapMenuFrameRate()).setSaveConsumer(config::setUncapMenuFrameRate).setTooltip(new class_2561[]{Components.translatable("config", "uncap_menu_frame_rate_tooltip", new Object[0])}).build());
        misc.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Components.translatable("config", "ignore_initial_click", new Object[0]), IgnoreInitialClick.class, (Enum)config.ignoreInitialClick()).setDefaultValue((Enum)defaultConfig.ignoreInitialClick()).setSaveConsumer(config::setIgnoreInitialClick).setEnumNameProvider(ClothConfig::ignoreInitialClickMessage).setTooltip(new class_2561[]{Components.translatable("config", "ignore_initial_click_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)misc.build());
        SubCategoryBuilder idle = entryBuilder.startSubCategory((class_2561)Components.translatable("config", "feature.idle", new Object[0]));
        idle.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Components.translatable("config", "idle_time", new Object[0]), config.idle().timeout() / 60, 0, 30).setDefaultValue(defaultConfig.idle().timeout() / 60).setSaveConsumer(value -> config.idle().setTimeout(value * 60)).setTextGetter(ClothConfig::idleTimeMessage).setTooltip(new class_2561[]{Components.translatable("config", "idle_time_tooltip", new Object[0])}).build());
        idle.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Components.translatable("config", "idle_condition", new Object[0]), IdleCondition.class, (Enum)config.idle().condition()).setDefaultValue((Enum)defaultConfig.idle().condition()).setSaveConsumer(config.idle()::setCondition).setEnumNameProvider(ClothConfig::IdleConditionMessage).setTooltipSupplier(ClothConfig::idleConditionTooltip).build());
        general.addEntry((AbstractConfigListEntry)idle.build());
        SubCategoryBuilder volumeTransition = entryBuilder.startSubCategory((class_2561)Components.translatable("config", "feature.volume_transition", new Object[0]));
        VariableStepTransformer volumeTransformer = ClothConfig.getVolumeStepTransformer();
        volumeTransition.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Components.translatable("config", "volume_transition_speed_up", new Object[0]), volumeTransformer.toStep((int)(config.volumeTransitionSpeed().getUp() * 100.0f)), 1, 73).setDefaultValue(volumeTransformer.toStep((int)(defaultConfig.volumeTransitionSpeed().getUp() * 100.0f))).setSaveConsumer(step -> config.volumeTransitionSpeed().setUp((float)volumeTransformer.toValue((int)step) / 100.0f)).setTextGetter(ClothConfig::volumeTransitionMessage).setTooltip(new class_2561[]{Components.translatable("config", "volume_transition_speed_tooltip", new Object[0])}).build());
        volumeTransition.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Components.translatable("config", "volume_transition_speed_down", new Object[0]), volumeTransformer.toStep((int)(config.volumeTransitionSpeed().getDown() * 100.0f)), 1, 73).setDefaultValue(volumeTransformer.toStep((int)(defaultConfig.volumeTransitionSpeed().getDown() * 100.0f))).setSaveConsumer(step -> config.volumeTransitionSpeed().setDown((float)volumeTransformer.toValue((int)step) / 100.0f)).setTextGetter(ClothConfig::volumeTransitionMessage).setTooltip(new class_2561[]{Components.translatable("config", "volume_transition_speed_tooltip", new Object[0])}).build());
        general.addEntry((AbstractConfigListEntry)volumeTransition.build());
        SubCategoryBuilder battery = entryBuilder.startSubCategory((class_2561)Components.translatable("config", "feature.battery", new Object[0]));
        BatteryTrackerConfig batteryTracker = config.batteryTracker();
        battery.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "battery_tracker", new Object[0]), batteryTracker.enabled()).setDefaultValue(defaultConfig.batteryTracker().enabled()).setSaveConsumer(batteryTracker::setEnabled).setTooltip(new class_2561[]{Components.translatable("config", "battery_tracker_tooltip", new Object[0])}).build());
        battery.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "battery_tracker_switch_states", new Object[0]), batteryTracker.switchStates()).setDefaultValue(defaultConfig.batteryTracker().switchStates()).setSaveConsumer(batteryTracker::setSwitchStates).setTooltip(new class_2561[]{Components.translatable("config", "battery_tracker_switch_states_tooltip", new Object[0])}).build());
        battery.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "battery_tracker_notifications", new Object[0]), batteryTracker.notifications()).setDefaultValue(defaultConfig.batteryTracker().notifications()).setSaveConsumer(batteryTracker::setNotifications).setTooltip(new class_2561[]{Components.translatable("config", "battery_tracker_notifications_tooltip", new Object[0])}).build());
        battery.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Components.translatable("config", "battery_critical_level", new Object[0]), batteryTracker.criticalLevel(), 1, 50).setDefaultValue(defaultConfig.batteryTracker().criticalLevel()).setSaveConsumer(batteryTracker::setCriticalLevel).setTextGetter(ClothConfig::valueAsPercentMessage).setTooltip(new class_2561[]{Components.translatable("config", "battery_critical_level_tooltip", new Object[0])}).build());
        battery.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Components.translatable("config", "battery_indicator_condition", new Object[0]), BatteryIndicatorCondition.class, (Enum)batteryTracker.display().condition()).setDefaultValue((Enum)defaultConfig.batteryTracker().display().condition()).setSaveConsumer(batteryTracker.display()::setCondition).setEnumNameProvider(ClothConfig::batteryIndicatorConditionMessage).build());
        battery.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Components.translatable("config", "battery_indicator_placement", new Object[0]), BatteryIndicatorPlacement.class, (Enum)batteryTracker.display().placement()).setDefaultValue((Enum)defaultConfig.batteryTracker().display().placement()).setSaveConsumer(batteryTracker.display()::setPlacement).setEnumNameProvider(ClothConfig::batteryIndicatorPlacementMessage).build());
        general.addEntry((AbstractConfigListEntry)battery.build());
        VariableStepTransformer fpsTransformer = ClothConfig.getFpsTransformer();
        for (PowerState state : PowerState.values()) {
            if (state.configurabilityLevel == PowerState.ConfigurabilityLevel.NONE) continue;
            Config instance = config.get(state);
            Config standard = defaultConfig.get(state);
            ConfigCategory category = builder.getOrCreateCategory((class_2561)Components.translatable("config", "category." + state.toString().toLowerCase(Locale.ROOT), new Object[0]));
            category.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Components.translatable("config", "frame_rate_target", new Object[0]), fpsTransformer.toStep(instance.frameRateTarget()), 0, 68).setDefaultValue(fpsTransformer.toStep(standard.frameRateTarget())).setSaveConsumer(step -> instance.setFrameRateTarget(fpsTransformer.toValue((int)step))).setTextGetter(ClothConfig::fpsTargetMessage).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("options.vsync", new Object[0]), instance.enableVsync()).setDefaultValue(standard.enableVsync()).setSaveConsumer(instance::setEnableVsync).build());
            if (state.configurabilityLevel == PowerState.ConfigurabilityLevel.SOME) continue;
            SubCategoryBuilder volumes = entryBuilder.startSubCategory((class_2561)Components.translatable("config", "volume_multiplier", new Object[0]));
            for (class_3419 source : class_3419.values()) {
                String name = source.method_14840();
                volumes.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Components.translatable("soundCategory." + name, new Object[0]), (int)(instance.rawVolumeMultiplier(source) * 100.0f), 0, 100).setDefaultValue((int)(standard.rawVolumeMultiplier(source) * 100.0f)).setSaveConsumer(value -> instance.setVolumeMultiplier(source, (float)value.intValue() / 100.0f)).setTextGetter(ClothConfig::valueAsPercentMessage).build());
            }
            category.addEntry((AbstractConfigListEntry)volumes.build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)Components.translatable("config", "graphics_state", new Object[0]), GraphicsState.class, (Enum)instance.graphicsState()).setDefaultValue((Enum)standard.graphicsState()).setSaveConsumer(instance::setGraphicsState).setEnumNameProvider(ClothConfig::graphicsStateMessage).setTooltipSupplier(ClothConfig::graphicsStateTooltip).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "show_toasts", new Object[0]), instance.showToasts()).setDefaultValue(standard.showToasts()).setSaveConsumer(instance::setShowToasts).setTooltip(new class_2561[]{Components.translatable("config", "show_toasts_tooltip", new Object[0])}).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "run_garbage_collector", new Object[0]), instance.runGarbageCollector()).setDefaultValue(standard.runGarbageCollector()).setSaveConsumer(instance::setRunGarbageCollector).setTooltip(new class_2561[]{Components.translatable("config", "run_garbage_collector_tooltip", new Object[0])}).build());
        }
        ConfigCategory advanced = builder.getOrCreateCategory((class_2561)Components.translatable("config", "category.advanced", new Object[0]));
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "download_natives", new Object[0]), config.downloadNatives()).setDefaultValue(defaultConfig.downloadNatives()).setSaveConsumer(config::setDownloadNatives).setTooltip(new class_2561[]{Components.translatable("config", "download_natives_description_0", new Object[0]), Components.translatable("config", "download_natives_description_1", new Object[0])}).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Components.translatable("config", "mock_battery_data", new Object[0]), config.mockBatteryData()).setDefaultValue(defaultConfig.mockBatteryData()).setSaveConsumer(config::setMockBatteryData).build());
        return builder.build();
    }

    private static class_2561 idleTimeMessage(int value) {
        if (value == 0) {
            return Components.translatable("config", "disabled", new Object[0]);
        }
        return Components.translatable("config", "minutes", value);
    }

    private static VariableStepTransformer getVolumeStepTransformer() {
        VariableStepTransformer transformer = new VariableStepTransformer();
        transformer.addStep(1, 50);
        transformer.addStep(5, 100);
        transformer.addStep(10, 200);
        transformer.addStep(100, 300);
        transformer.addStep(700, 1000);
        return transformer;
    }

    private static class_2561 volumeTransitionMessage(int step) {
        int value = ClothConfig.getVolumeStepTransformer().toValue(step);
        if (value <= 300) {
            return Components.literal(value + "%");
        }
        return Components.translatable("config", "volume_transition_speed_instant", new Object[0]);
    }

    private static VariableStepTransformer getFpsTransformer() {
        VariableStepTransformer transformer = new VariableStepTransformer();
        transformer.addStep(1, 20);
        transformer.addStep(2, 72);
        transformer.addStep(3, 75);
        transformer.addStep(5, 100);
        transformer.addStep(10, 260);
        return transformer;
    }

    private static class_2561 fpsTargetMessage(int step) {
        int fps = ClothConfig.getFpsTransformer().toValue(step);
        if (fps != 260) {
            return Components.translatable("options.framerate", fps);
        }
        return Components.translatable("options.framerateLimit.max", new Object[0]);
    }

    private static class_2561 valueAsPercentMessage(int value) {
        return Components.literal(Integer.toString(value) + "%");
    }

    public static class_2561 ignoreInitialClickMessage(Enum<IdleCondition> state) {
        return Components.translatable("config", "ignore_initial_click_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    public static class_2561 IdleConditionMessage(Enum<IdleCondition> state) {
        return Components.translatable("config", "idle_condition_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    private static Optional<class_2561[]> idleConditionTooltip(IdleCondition condition) {
        return Optional.of(new class_2561[]{Components.translatable("config", "idle_condition_" + condition.toString().toLowerCase(Locale.ROOT) + "_tooltip", new Object[0])});
    }

    private static class_2561 graphicsStateMessage(Enum<GraphicsState> graphicsState) {
        return Components.translatable("config", "graphics_state_" + graphicsState.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    public static class_2561 batteryIndicatorConditionMessage(Enum<BatteryIndicatorCondition> state) {
        return Components.translatable("config", "battery_indicator_condition_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    public static class_2561 batteryIndicatorPlacementMessage(Enum<BatteryIndicatorPlacement> state) {
        return Components.translatable("config", "battery_indicator_placement_" + state.toString().toLowerCase(Locale.ROOT), new Object[0]);
    }

    private static Optional<class_2561[]> graphicsStateTooltip(GraphicsState graphicsState) {
        if (!graphicsState.equals((Object)GraphicsState.MINIMAL)) {
            return Optional.empty();
        }
        return Optional.of(new class_2561[]{Components.translatable("config", "graphics_state_minimal_tooltip", new Object[0]).method_27692(class_124.field_1061)});
    }
}

