/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.mixins;

import net.minecraft.class_310;
import net.xolt.freecam.LegacyFreecam;
import net.xolt.freecam.config.ModBindings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public class MinecraftMixin {
    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDoAttack(CallbackInfoReturnable<Boolean> cir) {
        if (MinecraftMixin.freecam$disableInteract()) {
            cir.cancel();
        }
    }

    @Inject(method={"pickBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDoItemPick(CallbackInfo ci) {
        if (MinecraftMixin.freecam$disableInteract()) {
            ci.cancel();
        }
    }

    @Inject(method={"continueAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleBlockBreaking(CallbackInfo ci) {
        if (MinecraftMixin.freecam$disableInteract()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleKeybinds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;consumeClick()Z", ordinal=2)}, cancellable=true)
    private void onHandleInputEvents(CallbackInfo ci) {
        if (ModBindings.KEY_TOGGLE.get().method_1434() || ModBindings.KEY_TRIPOD_RESET.get().method_1434()) {
            ci.cancel();
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="HEAD")})
    private void onDisconnect(CallbackInfo ci) {
        LegacyFreecam.onDisconnect();
    }

    @Unique
    private static boolean freecam$disableInteract() {
        return LegacyFreecam.isEnabled();
    }

    @Unique
    private static boolean freecam$allowInteract() {
        return !LegacyFreecam.isEnabled();
    }
}

