/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import ca.stellardrift.confabricate.Confabricate;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.BobbyConfigScreenFactory;
import de.johni0702.minecraft.bobby.FakeChunk;
import de.johni0702.minecraft.bobby.FakeChunkManager;
import de.johni0702.minecraft.bobby.LastAccessFile;
import de.johni0702.minecraft.bobby.Worlds;
import de.johni0702.minecraft.bobby.commands.CreateWorldCommand;
import de.johni0702.minecraft.bobby.commands.MergeWorldsCommand;
import de.johni0702.minecraft.bobby.commands.UpgradeCommand;
import de.johni0702.minecraft.bobby.commands.WorldsCommand;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import de.johni0702.minecraft.bobby.mixin.SimpleOptionAccessor;
import de.johni0702.minecraft.bobby.mixin.ValidatingIntSliderCallbacksAccessor;
import de.johni0702.minecraft.bobby.util.FlawlessFrames;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_7172;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.reference.ValueReference;
import org.spongepowered.configurate.reference.WatchServiceListener;

public class Bobby
implements ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "bobby";
    private static Bobby instance;
    private static final class_310 client;
    private ValueReference<BobbyConfig, CommentedConfigurationNode> configReference;

    public Bobby() {
        instance = this;
    }

    public static Bobby getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("bobby.conf");
            ConfigurationReference rootRef = Bobby.getOrCreateWatchServiceListener().listenToConfiguration(path -> ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(path)).build(), configPath);
            this.configReference = rootRef.referenceTo(BobbyConfig.class, new Object[0]);
            rootRef.saveAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)MOD_ID).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"worlds").executes((Command)new WorldsCommand(false))).then(ClientCommandManager.literal((String)"full").executes((Command)new WorldsCommand(true)))).then(ClientCommandManager.literal((String)"merge").then(ClientCommandManager.argument((String)"source", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"target", (ArgumentType)IntegerArgumentType.integer()).executes((Command)new MergeWorldsCommand()))))).then(ClientCommandManager.literal((String)"create").executes((Command)new CreateWorldCommand())))).then(ClientCommandManager.literal((String)"upgrade").executes((Command)new UpgradeCommand()))));
        FlawlessFrames.onClientInitialization();
        this.configReference.subscribe(new TaintChunksConfigHandler()::update);
        this.configReference.subscribe(new MaxRenderDistanceConfigHandler()::update);
        class_156.method_27958().execute(this::cleanupOldWorlds);
    }

    public BobbyConfig getConfig() {
        return this.configReference != null ? (BobbyConfig)this.configReference.get() : BobbyConfig.DEFAULT;
    }

    public boolean isEnabled() {
        BobbyConfig config = this.getConfig();
        return config.isEnabled() && (client.method_1576() == null || config.getViewDistanceOverwrite() != 0);
    }

    public class_437 createConfigScreen(class_437 parent) {
        if (FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            return BobbyConfigScreenFactory.createConfigScreen(parent, this.getConfig(), arg_0 -> this.configReference.setAndSaveAsync(arg_0));
        }
        return null;
    }

    private void cleanupOldWorlds() {
        List toBeDeleted;
        int deleteUnusedRegionsAfterDays = Bobby.getInstance().getConfig().getDeleteUnusedRegionsAfterDays();
        if (deleteUnusedRegionsAfterDays < 0) {
            return;
        }
        Path basePath = Bobby.client.field_1697.toPath().resolve(".bobby");
        try (Stream<Path> stream = Files.walk(basePath, 4, new FileVisitOption[0]);){
            toBeDeleted = stream.filter(it -> basePath.relativize((Path)it).getNameCount() == 4).flatMap(directory -> {
                try {
                    ArrayList toDelete = new ArrayList();
                    if (Files.exists(Worlds.metaFile(directory), new LinkOption[0])) {
                        List worlds;
                        try (Stream<Path> fStream = Files.list(directory);){
                            worlds = fStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                        }
                        boolean stillHasWorlds = false;
                        for (Path world : worlds) {
                            if (LastAccessFile.isEverythingOlderThan(world, deleteUnusedRegionsAfterDays)) {
                                Stream<Path> fStream = Files.list(world);
                                try {
                                    fStream.forEach(toDelete::add);
                                    continue;
                                }
                                finally {
                                    if (fStream != null) {
                                        fStream.close();
                                    }
                                    continue;
                                }
                            }
                            stillHasWorlds = true;
                        }
                        if (!stillHasWorlds && LastAccessFile.isEverythingOlderThan(directory, deleteUnusedRegionsAfterDays)) {
                            try (Stream<Path> fStream = Files.list(directory);){
                                fStream.forEach(toDelete::add);
                            }
                        }
                    } else {
                        try (Stream<Path> fStream = Files.walk(directory, 2, new FileVisitOption[0]);){
                            fStream.filter(it -> it.relativize((Path)directory).getNameCount() == 2).forEach(toDelete::add);
                        }
                        if (LastAccessFile.isEverythingOlderThan(directory, deleteUnusedRegionsAfterDays)) {
                            fStream = Files.list(directory);
                            try {
                                fStream.filter(it -> !Files.isDirectory(it, new LinkOption[0])).forEach(toDelete::add);
                            }
                            finally {
                                if (fStream != null) {
                                    fStream.close();
                                }
                            }
                        }
                    }
                    return toDelete.stream();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read last used file in " + String.valueOf(directory) + ":", (Throwable)e);
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Failed to index bobby cache for cleanup:", (Throwable)e);
            return;
        }
        for (Path path : toBeDeleted) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                Files.delete(path);
                Bobby.deleteParentsIfEmpty(path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete " + String.valueOf(path) + ":", (Throwable)e);
            }
        }
    }

    private static void deleteParentsIfEmpty(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent == null) {
            return;
        }
        try (Stream<Path> stream = Files.list(parent);){
            if (stream.findAny().isPresent()) {
                return;
            }
        }
        Files.delete(parent);
        Bobby.deleteParentsIfEmpty(parent);
    }

    private static WatchServiceListener getOrCreateWatchServiceListener() throws IOException {
        try {
            return Confabricate.fileWatcher();
        }
        catch (NoClassDefFoundError | NoSuchMethodError ignored) {
            return Bobby.createWatchServiceListener();
        }
    }

    private static WatchServiceListener createWatchServiceListener() throws IOException {
        WatchServiceListener listener = WatchServiceListener.create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                listener.close();
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
            }
        }, "Configurate shutdown thread (Bobby)"));
        return listener;
    }

    static {
        client = class_310.method_1551();
    }

    private class TaintChunksConfigHandler {
        private boolean wasEnabled;

        private TaintChunksConfigHandler() {
            this.wasEnabled = Bobby.this.getConfig().isTaintFakeChunks();
        }

        public void update(BobbyConfig config) {
            client.execute(() -> this.setEnabled(config.isTaintFakeChunks()));
        }

        private void setEnabled(boolean enabled) {
            if (this.wasEnabled == enabled) {
                return;
            }
            this.wasEnabled = enabled;
            class_638 world = Bobby.client.field_1687;
            if (world == null) {
                return;
            }
            FakeChunkManager bobbyChunkManager = ((ClientChunkManagerExt)world.method_2935()).bobby_getFakeChunkManager();
            if (bobbyChunkManager == null) {
                return;
            }
            for (class_2818 fakeChunk : bobbyChunkManager.getFakeChunks()) {
                ((FakeChunk)fakeChunk).setTainted(enabled);
            }
        }
    }

    private class MaxRenderDistanceConfigHandler {
        private int oldMaxRenderDistance = 0;

        private MaxRenderDistanceConfigHandler() {
            this.update(Bobby.this.getConfig(), true);
        }

        public void update(BobbyConfig config) {
            this.update(config, false);
        }

        public void update(BobbyConfig config, boolean increaseOnly) {
            client.execute(() -> this.setMaxRenderDistance(config.getMaxRenderDistance(), increaseOnly));
        }

        private void setMaxRenderDistance(int newMaxRenderDistance, boolean increaseOnly) {
            if (this.oldMaxRenderDistance == newMaxRenderDistance) {
                return;
            }
            this.oldMaxRenderDistance = newMaxRenderDistance;
            class_7172 viewDistance = Bobby.client.field_1690.method_42503();
            class_7172.class_7178 class_71782 = viewDistance.method_41754();
            if (class_71782 instanceof class_7172.class_7174) {
                class_7172.class_7174 callbacks = (class_7172.class_7174)class_71782;
                ValidatingIntSliderCallbacksAccessor callbacksAcc = (ValidatingIntSliderCallbacksAccessor)callbacks;
                if (increaseOnly) {
                    callbacksAcc.setMaxInclusive(Math.max(callbacks.comp_594(), newMaxRenderDistance));
                } else {
                    callbacksAcc.setMaxInclusive(newMaxRenderDistance);
                }
                SimpleOptionAccessor optionAccessor = (SimpleOptionAccessor)viewDistance;
                optionAccessor.setCodec(callbacks.comp_675());
            }
        }
    }
}

