/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.cape;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import com.mojang.authlib.GameProfile;
import com.wildfire.main.WildfireGender;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapeProvider {
    public static final class_2960 NO_CAPE = class_2960.method_60655((String)"wildfire_gender", (String)"no_cape");
    private static final Duration CACHE_DURATION = (Duration)class_156.method_656(() -> {
        if (Objects.equals(System.getProperty("wildfiregender.capes.cache.debug"), "true")) {
            return Duration.ofSeconds(5L);
        }
        return Duration.ofMinutes(30L);
    });
    public static final LoadingCache<GameProfile, CompletableFuture<class_2960>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(CACHE_DURATION).removalListener(CapeProvider::remove).build((CacheLoader)new CacheLoader<GameProfile, CompletableFuture<class_2960>>(){

        public @NotNull CompletableFuture<@Nullable class_2960> load(@NotNull GameProfile key) {
            return CapeProvider.loadCape(key);
        }
    });
    private static final Pattern USERNAME = Pattern.compile("^[a-z0-9_]{1,16}$", 2);
    private static final String CAPE_URL = "https://femalegendermod.net/capes/{uuid}.png";

    private static void remove(RemovalNotification<GameProfile, CompletableFuture<@Nullable class_2960>> entry) {
        CompletableFuture future = (CompletableFuture)entry.getValue();
        if (future == null) {
            WildfireGender.LOGGER.warn("Got a null value for removed cache entry with key {}; this shouldn't happen!", entry.getKey());
            return;
        }
        class_2960 id = future.getNow(null);
        if (id != null) {
            class_310.method_1551().method_1531().method_4615(id);
        }
    }

    private static CompletableFuture<@Nullable class_2960> loadCape(GameProfile player) {
        return CompletableFuture.supplyAsync(() -> {
            if (player.getId().version() != 4 || !USERNAME.matcher(player.getName()).matches()) {
                return null;
            }
            return CapeProvider.tryUrl(player, CAPE_URL.replace("{uuid}", player.getId().toString()));
        }, (Executor)class_156.method_27958());
    }

    private static class_1011 uncrop(class_1011 in) {
        int srcHeight = in.method_4323();
        int srcWidth = in.method_4307();
        int zoom = (int)Math.ceil((float)in.method_4323() / 32.0f);
        class_1011 out = new class_1011(64 * zoom, 32 * zoom, true);
        for (int x = 0; x < srcWidth; ++x) {
            for (int y = 0; y < srcHeight; ++y) {
                out.method_61941(x, y, in.method_61940(x, y));
            }
        }
        return out;
    }

    @Nullable
    private static class_2960 tryUrl(GameProfile player, String urlFrom) {
        try {
            WildfireGender.LOGGER.debug("Attempting to fetch cape from {}", (Object)urlFrom);
            URL url = URI.create(urlFrom).toURL();
            class_1011 image = CapeProvider.uncrop(class_1011.method_4309((InputStream)url.openStream()));
            WildfireGender.LOGGER.debug("Got cape texture");
            class_2960 id = class_2960.method_60655((String)"wildfire_gender", (String)("cape/" + player.getId().toString().replace("-", "")));
            CapeProvider.register(id, image).join();
            return id;
        }
        catch (FileNotFoundException e) {
            WildfireGender.LOGGER.debug("No cape texture found");
            return NO_CAPE;
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to fetch cape texture", (Throwable)e);
            return null;
        }
    }

    private static CompletableFuture<Void> register(class_2960 id, class_1011 image) {
        return class_310.method_1551().method_20493(() -> {
            class_1043 texture = new class_1043(() -> ((class_2960)id).toString(), image);
            class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
        });
    }

    private CapeProvider() {
        throw new UnsupportedOperationException();
    }
}

